import sys


def algo_params(param_str):
    """
      Return params list based on param_str.
      These are the parameters used to produce the figures in the paper
      For AlphaX and Reinforcement Learning, we used the corresponding github repos:
      https://github.com/linnanwang/AlphaX-NASBench101
      https://github.com/automl/nas_benchmarks
    """
    params = []

    if param_str == 'test':
        params.append({'algo_name':'bananas', 'total_queries':30})   
        params.append({'algo_name':'random', 'total_queries':30})
        params.append({'algo_name':'evolution', 'total_queries':30})
        params.append({'algo_name':'gp_bayesopt', 'total_queries':30})


    elif param_str == 'random':
        params.append({'algo_name':'random', 'total_queries':500, 'random':'uniform'})
        params.append({'algo_name':'random', 'total_queries':500, 'random':'continuous'})
        params.append({'algo_name':'random', 'total_queries':500, 'random':'adjacency'})
        params.append({'algo_name':'random', 'total_queries':500, 'random':'path'})
        params.append({'algo_name':'random', 'total_queries':500, 'random':'path_freq'})
        params.append({'algo_name':'random', 'total_queries':500, 'random':'path_cont'})
        params.append({'algo_name':'random', 'total_queries':500, 'random':'path_cont_freq'})

    elif param_str == 'evo_mutate':
        params.append({'algo_name':'evolution', 'total_queries':500, 'mutate_type':'adjacency'})
        params.append({'algo_name':'evolution', 'total_queries':500, 'mutate_type':'adj_cat'})
        params.append({'algo_name':'evolution', 'total_queries':500, 'mutate_type':'path', 'cutoff':400})
        params.append({'algo_name':'evolution', 'total_queries':500, 'mutate_type':'path_freq'})
        params.append({'algo_name':'evolution', 'total_queries':500, 'mutate_type':'path_cat'})
        params.append({'algo_name':'evolution', 'total_queries':500, 'mutate_type':'path_cat_freq'})

    elif param_str == 'ls_mutate':
        params.append({'algo_name':'local_search', 'total_queries':500, 'nbhd_type_pattern':['path']})
        params.append({'algo_name':'local_search', 'total_queries':500, 'nbhd_type_pattern':['path_freq']})
        params.append({'algo_name':'local_search', 'total_queries':500, 'nbhd_type_pattern':['adj']})

    elif param_str == 'bo':
        params.append({'algo_name':'gp_bayesopt', 'total_queries':150, 'distance':'freq_distance'})
        params.append({'algo_name':'gp_bayesopt', 'total_queries':150, 'distance':'path_distance'})
        params.append({'algo_name':'gp_bayesopt', 'total_queries':150, 'distance':'edit_distance'})
        params.append({'algo_name':'gp_bayesopt', 'total_queries':150, 'distance':'nasbot_distance'})
        params.append({'algo_name':'gp_bayesopt', 'total_queries':150, 'distance':'cont_distance'})

    elif param_str == 'bananas':
        params.append({'algo_name':'bananas', 'total_queries':150, 'encoding_type':'path_cat'})
        params.append({'algo_name':'bananas', 'total_queries':150, 'encoding_type':'path_cat_freq'})
        params.append({'algo_name':'bananas', 'total_queries':150, 'encoding_type':'path'})
        params.append({'algo_name':'bananas', 'total_queries':150, 'encoding_type':'path_freq'})
        params.append({'algo_name':'bananas', 'total_queries':150, 'encoding_type':'adj'})
        params.append({'algo_name':'bananas', 'total_queries':150, 'encoding_type':'adj_cat'})
        params.append({'algo_name':'bananas', 'total_queries':150, 'encoding_type':'continuous'})

    else:
        print('invalid algorithm params: {}'.format(param_str))
        sys.exit()

    print('\n* Running experiment: ' + param_str)
    return params


def meta_neuralnet_params(param_str):

    if param_str == 'nasbench':
        params = {'search_space':'nasbench', 'dataset':'cifar10', 'mf':False, 'loss':'mae', 'num_layers':10, 'layer_width':20, \
            'epochs':150, 'batch_size':32, 'lr':.01, 'regularization':0, 'verbose':0}

    elif param_str == 'mf_nasbench':
        params = {'search_space':'nasbench', 'dataset':'cifar10', 'mf':True, 'loss':'mae', 'num_layers':10, 'layer_width':20, \
            'epochs':150, 'batch_size':32, 'lr':.01, 'regularization':0, 'verbose':0}

    elif param_str == 'darts':
        params = {'search_space':'darts', 'dataset':'cifar10', 'mf':False, 'loss':'mape', 'num_layers':10, 'layer_width':20, \
            'epochs':10000, 'batch_size':32, 'lr':.00001, 'regularization':0, 'verbose':0}

    elif param_str == 'nasbench_outside':
        params = {'search_space':'nasbench', 'dataset':'cifar10', 'mf':False, 'loss':'mse', 'num_layers':10, 'layer_width':20, \
            'epochs':500, 'batch_size':32, 'lr':.01, 'regularization':0, 'verbose':0}

    elif param_str == 'nasbench_201_cifar10':
        params = {'search_space':'nasbench_201', 'dataset':'cifar10', 'mf':False, 'loss':'mae', 'num_layers':10, 'layer_width':20, \
            'epochs':150, 'batch_size':32, 'lr':.01, 'regularization':0, 'verbose':0}

    elif param_str == 'nasbench_201_cifar100':
        params = {'search_space':'nasbench_201', 'dataset':'cifar100', 'mf':False, 'loss':'mae', 'num_layers':10, 'layer_width':20, \
            'epochs':150, 'batch_size':32, 'lr':.01, 'regularization':0, 'verbose':0}

    elif param_str == 'nasbench_201_imagenet':
        params = {'search_space':'nasbench_201', 'dataset':'ImageNet16-120', 'mf':False, 'loss':'mae', 'num_layers':10, 'layer_width':20, \
            'epochs':150, 'batch_size':32, 'lr':.01, 'regularization':0, 'verbose':0}

    else:
        print('invalid meta neural net params: {}'.format(param_str))
        sys.exit()

    return params
