# Adaptive Graph Convolutional Recurrent Network for Traffic Forecasting

This folder concludes the code and data of our AGCRN model.

## Structure:

* data: including PEMSD4 and PEMSD8 dataset used in our experiments

* lib: contains self-defined modules for our work, such as data loading, data pre-process, normalization, and evaluate metrics.

* model: implementation of our AGCRN model

* pre-trained: saved models for PEMSD4 and PEMSD8 dataset

## Requirements

Python 3.6.5, Pytorch 1.1.0, Numpy 1.16.3, argparse and configparser

## Training

Suppose CUDA is available,  just enter the **code/model/** folder and run:

python ./RunPEMSD4.py --mode=train

python ./RunPEMSD8.py --mode=train

## Evaluation:

Suppose CUDA is available, just enter the **code/model/** folder and run:

python ./RunPEMSD4.py --mode=test

python ./RunPEMSD8.py --mode=test

## Results:

The following results are tested in Linux system with TITAN X GPU

PEMSD4 dataset:

**MAE: 19.83, RMSE: 32.26, MAPE: 12.97%**

PEMSD8 dataset:

**MAE: 15.95, RMSE: 25.22, MAPE: 10.09%**

