# PyTorch Implementation of Differentiable ODE Solvers + Interpolation Techniques

This is a repository for the IRDM method. This repository was built on top of <https://github.com/rtqichen/torchdiffeq>. 
To apply IRDM, one has to create `odeint_chebyshev` function which has the same interface as `odeint_adjoint` as follows
```python
from interpolated_torchdiffeq import odeint_chebyshev_func
from functools import partial 

n_nodes = 10  # if you want 10 grid points
odeint_chebyshev = partial(odeint_chebyshev_func, n_nodes=n_nodes)
```

In this repository, we also modified `dopri5` from `torchdiffeq` to prevent it from running (t_min, t_max) interval.

It is also possible to run code from <https://github.com/rtqichen/ffjord> by replacing `odeint` function by `odeint_chebyshev`.
