data=cifar10
embeddings="raw pca_32 pca_64 pca_128 nca_64 alexnet_pt googlenet_pt inception_v3_tf efficientnet_b0_tf efficientnet_b1_tf efficientnet_b2_tf efficientnet_b3_tf efficientnet_b4_tf efficientnet_b5_tf efficientnet_b6_tf efficientnet_b7_tf resetnet_v2_101_tf resetnet_v2_152_tf resetnet_v2_50_tf vgg16_pt vgg19_pt"

ks=250

for suffix in $embeddings
do
  outputfolder=results/$data/knn_accuracy
  mkdir -p $outputfolder

  cmd="python lib/estimate.py --method knn --features_train matrices/$data/train/features_$suffix.npy --labels_train matrices/$data/train/labels_$suffix.npy --features_test matrices/$data/test/features_$suffix.npy --labels_test matrices/$data/test/labels_$suffix.npy -v 1 --output_file $outputfolder/$suffix.csv"

  i=1
  until [ $i -gt $ks ]
  do
    cmd="$cmd --knn_k $i"
    ((i=i+1))
  done

  echo "Running $cmd"
  $cmd
  echo "Done $cmd"
done
