/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleOptionHandler
extends OptionHandler<Double> {
    public DoubleOptionHandler(CmdLineParser parser, Option option, Setter<? super Double> setter) {
        super(parser, option, setter);
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        String token = params.getParameter(0);
        try {
            double value = Double.parseDouble(token);
            this.setter.addValue(value);
        }
        catch (NumberFormatException ex) {
            throw new CmdLineException(Messages.ILLEGAL_OPERAND.format(params.getOptionName(), token));
        }
        return 1;
    }

    @Override
    public String getDefaultMetaVariable() {
        return "N";
    }
}

