/*
 * Decompiled with CFR 0.152.
 */
package models;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import utility.FuncUtils;

public class PTM {
    public double alpha;
    public double beta;
    public double gama;
    public int numTopics;
    public int numIterations;
    public int topWords;
    public double alphaSum;
    public double betaSum;
    public double gamaSum;
    ArrayList<int[]> Corpus = new ArrayList();
    public int numShorDoc;
    public int numWordsInCorpus;
    public HashMap<String, Integer> word2IdVocabulary;
    public HashMap<Integer, String> id2WordVocabulary;
    public int vocabularySize;
    public int numLongDoc;
    private int[][] U;
    private int[] m_z;
    private int[] n_z;
    private int[] z;
    private int[][] z_w;
    private int[][] V;
    private int[] topicCnts;
    private int[][] shortDocTopicCnts;
    int[] N_d;
    public double[] multiLongPros;
    public double[] multiTopicPros;
    public String folderPath;
    public String corpusPath;
    public String expName = "PTMmodel";
    public String orgExpName = "PTMmodel";
    public String tAssignsFilePath = "";
    public int savestep = 0;
    public double initTime = 0.0;
    public double iterTime = 0.0;

    public PTM(String pathToCorpus, int inNumTopics, int num_longDoc, double inAlpha, double inBeta, double inGama, int inNumIterations, int inTopWords) throws Exception {
        this(pathToCorpus, inNumTopics, num_longDoc, inAlpha, inBeta, inGama, inNumIterations, inTopWords, "PTMmodel");
    }

    public PTM(String pathToCorpus, int inNumTopics, int num_longDoc, double inAlpha, double inBeta, double inGama, int inNumIterations, int inTopWords, String inExpName) throws Exception {
        this(pathToCorpus, inNumTopics, num_longDoc, inAlpha, inBeta, inGama, inNumIterations, inTopWords, inExpName, "", 0);
    }

    public PTM(String pathToCorpus, int inNumTopics, int num_longDoc, double inAlpha, double inBeta, double inGama, int inNumIterations, int inTopWords, String inExpName, String pathToTAfile) throws Exception {
        this(pathToCorpus, inNumTopics, num_longDoc, inAlpha, inBeta, inGama, inNumIterations, inTopWords, inExpName, pathToTAfile, 0);
    }

    public PTM(String pathToCorpus, int inNumTopics, int num_longDoc, double inAlpha, double inBeta, double inGama, int inNumIterations, int inTopWords, String inExpName, int inSaveStep) throws Exception {
        this(pathToCorpus, inNumTopics, num_longDoc, inAlpha, inBeta, inGama, inNumIterations, inTopWords, inExpName, "", inSaveStep);
    }

    public PTM(String pathToCorpus, int inNumTopics, int num_longDoc, double inAlpha, double inBeta, double inGama, int inNumIterations, int inTopWords, String inExpName, String pathToTAfile, int inSaveStep) throws IOException {
        int i;
        this.alpha = inAlpha;
        this.beta = inBeta;
        this.gama = inGama;
        this.numTopics = inNumTopics;
        this.numIterations = inNumIterations;
        this.topWords = inTopWords;
        this.savestep = inSaveStep;
        this.orgExpName = this.expName = inExpName;
        this.corpusPath = pathToCorpus;
        this.numLongDoc = num_longDoc;
        this.folderPath = "results/";
        File dir = new File(this.folderPath);
        if (!dir.exists()) {
            dir.mkdir();
        }
        System.out.println("Reading topic modeling corpus: " + pathToCorpus);
        this.word2IdVocabulary = new HashMap();
        this.id2WordVocabulary = new HashMap();
        this.numShorDoc = 0;
        this.numWordsInCorpus = 0;
        BufferedReader br = null;
        try {
            String doc;
            int indexWord = -1;
            br = new BufferedReader(new FileReader(pathToCorpus));
            while ((doc = br.readLine()) != null) {
                if (doc.trim().length() == 0) continue;
                String[] words = doc.trim().split("\\s+");
                int[] document = new int[words.length];
                int ind = 0;
                for (String word : words) {
                    if (this.word2IdVocabulary.containsKey(word)) {
                        document[ind++] = this.word2IdVocabulary.get(word);
                        continue;
                    }
                    this.word2IdVocabulary.put(word, ++indexWord);
                    this.id2WordVocabulary.put(indexWord, word);
                    document[ind++] = indexWord;
                }
                ++this.numShorDoc;
                this.numWordsInCorpus += document.length;
                this.Corpus.add(document);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.vocabularySize = this.word2IdVocabulary.size();
        this.z = new int[this.numShorDoc];
        this.z_w = new int[this.numShorDoc][];
        this.multiTopicPros = new double[this.numTopics];
        for (i = 0; i < this.numTopics; ++i) {
            this.multiTopicPros[i] = 1.0 / (double)this.numTopics;
        }
        this.multiLongPros = new double[this.numLongDoc];
        for (i = 0; i < this.numLongDoc; ++i) {
            this.multiLongPros[i] = 1.0 / (double)this.numLongDoc;
        }
        this.alphaSum = (double)this.numTopics * this.alpha;
        this.betaSum = (double)this.vocabularySize * this.beta;
        this.gamaSum = this.gama * (double)this.vocabularySize;
        this.U = new int[this.numTopics][this.numLongDoc];
        this.m_z = new int[this.numLongDoc];
        this.n_z = new int[this.numLongDoc];
        this.V = new int[this.vocabularySize][this.numTopics];
        this.topicCnts = new int[this.numTopics];
        this.shortDocTopicCnts = new int[this.numShorDoc][this.numTopics];
        this.N_d = new int[this.numShorDoc];
        System.out.println("Corpus size: " + this.numShorDoc + " docs, " + this.numWordsInCorpus + " words");
        System.out.println("Vocabuary size: " + this.vocabularySize);
        System.out.println("Number of topics: " + this.numTopics);
        System.out.println("alpha: " + this.alpha);
        System.out.println("beta: " + this.beta);
        System.out.println("Number of sampling iterations: " + this.numIterations);
        System.out.println("Number of top topical words: " + this.topWords);
        this.initialize();
    }

    public void initialize() throws IOException {
        System.out.println("Randomly initializing topic assignments ...");
        long startTime = System.currentTimeMillis();
        for (int d = 0; d < this.numShorDoc; ++d) {
            int longDoc;
            int[] termIDArray = this.Corpus.get(d);
            this.z[d] = longDoc = FuncUtils.nextDiscrete(this.multiLongPros);
            int n = longDoc;
            this.m_z[n] = this.m_z[n] + 1;
            int n2 = longDoc;
            this.n_z[n2] = this.n_z[n2] + termIDArray.length;
            this.z_w[d] = new int[termIDArray.length];
            this.N_d[d] = termIDArray.length;
            for (int t = 0; t < termIDArray.length; ++t) {
                int termID = termIDArray[t];
                int topic = FuncUtils.nextDiscrete(this.multiTopicPros);
                int[] nArray = this.shortDocTopicCnts[d];
                int n3 = topic;
                nArray[n3] = nArray[n3] + 1;
                int n4 = topic;
                this.topicCnts[n4] = this.topicCnts[n4] + 1;
                this.z_w[d][t] = topic;
                int[] nArray2 = this.U[topic];
                int n5 = longDoc;
                nArray2[n5] = nArray2[n5] + 1;
                int[] nArray3 = this.V[termID];
                int n6 = topic;
                nArray3[n6] = nArray3[n6] + 1;
            }
        }
        this.initTime = System.currentTimeMillis() - startTime;
        System.out.println("finish init_PTM!");
    }

    private int sampleFullConditionalForLong(int m) {
        int n;
        int pre_long;
        int n2 = pre_long = this.z[m];
        this.m_z[n2] = this.m_z[n2] - 1;
        int n3 = pre_long;
        this.n_z[n3] = this.n_z[n3] - this.N_d[m];
        for (n = 0; n < this.Corpus.get(m).length; ++n) {
            int topic = this.z_w[m][n];
            int[] nArray = this.U[topic];
            int n4 = pre_long;
            nArray[n4] = nArray[n4] - 1;
        }
        int tIndex = 0;
        while (tIndex < this.numLongDoc) {
            this.multiLongPros[tIndex] = this.m_z[tIndex];
            for (int k = 0; k < this.numTopics; ++k) {
                if (this.shortDocTopicCnts[m][k] == 0) continue;
                for (int i = 1; i <= this.shortDocTopicCnts[m][k]; ++i) {
                    int n5 = tIndex;
                    this.multiLongPros[n5] = this.multiLongPros[n5] * ((double)this.U[k][tIndex] + this.alpha + (double)i - 1.0);
                }
            }
            double prob = 1.0;
            for (int wIndex = 0; wIndex < this.N_d[m]; ++wIndex) {
                prob *= (double)this.n_z[tIndex] + this.alphaSum + (double)wIndex;
            }
            int n6 = tIndex++;
            this.multiLongPros[n6] = this.multiLongPros[n6] / prob;
        }
        int n7 = pre_long = FuncUtils.nextDiscrete(this.multiLongPros);
        this.m_z[n7] = this.m_z[n7] + 1;
        int n8 = pre_long;
        this.n_z[n8] = this.n_z[n8] + this.N_d[m];
        for (n = 0; n < this.Corpus.get(m).length; ++n) {
            int topic = this.z_w[m][n];
            int[] nArray = this.U[topic];
            int n9 = pre_long;
            nArray[n9] = nArray[n9] + 1;
        }
        return pre_long;
    }

    private int sampleFullConditionalForWordTopic(int preLong, int m, int n) {
        int topic = this.z_w[m][n];
        int wordId = this.Corpus.get(m)[n];
        int[] nArray = this.V[wordId];
        int n2 = topic;
        nArray[n2] = nArray[n2] - 1;
        int[] nArray2 = this.U[topic];
        int n3 = preLong;
        nArray2[n3] = nArray2[n3] - 1;
        int n4 = topic;
        this.topicCnts[n4] = this.topicCnts[n4] - 1;
        int[] nArray3 = this.shortDocTopicCnts[m];
        int n5 = topic;
        nArray3[n5] = nArray3[n5] - 1;
        for (int k = 0; k < this.numTopics; ++k) {
            this.multiTopicPros[k] = ((double)this.V[wordId][k] + this.beta) / ((double)this.topicCnts[k] + this.betaSum) * ((double)this.U[k][preLong] + this.alpha);
        }
        topic = FuncUtils.nextDiscrete(this.multiTopicPros);
        int[] nArray4 = this.V[wordId];
        int n6 = topic;
        nArray4[n6] = nArray4[n6] + 1;
        int[] nArray5 = this.U[topic];
        int n7 = preLong;
        nArray5[n7] = nArray5[n7] + 1;
        int n8 = topic;
        this.topicCnts[n8] = this.topicCnts[n8] + 1;
        int[] nArray6 = this.shortDocTopicCnts[m];
        int n9 = topic;
        nArray6[n9] = nArray6[n9] + 1;
        return topic;
    }

    public void inference() throws IOException {
        this.writeDictionary();
        System.out.println("Running Gibbs sampling inference: ");
        long startTime = System.currentTimeMillis();
        for (int iter = 0; iter < this.numIterations; ++iter) {
            if (iter % 50 == 0) {
                System.out.print(" " + iter);
            }
            for (int s = 0; s < this.Corpus.size(); ++s) {
                int preLong;
                this.z[s] = preLong = this.sampleFullConditionalForLong(s);
                for (int wIndex = 0; wIndex < this.Corpus.get(s).length; ++wIndex) {
                    int topic;
                    this.z_w[s][wIndex] = topic = this.sampleFullConditionalForWordTopic(preLong, s, wIndex);
                }
            }
        }
        this.iterTime = System.currentTimeMillis() - startTime;
        this.expName = this.orgExpName;
        System.out.println();
        System.out.println("Writing output from the last sample ...");
        this.write();
        System.out.println("Sampling completed for PTM!");
    }

    public void write() throws IOException {
        this.writeTopTopicalWords();
        this.writeDocTopicPros();
        this.writeTopicWordPros();
        this.writeParameters();
    }

    public void writeDocTopicPros() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".theta"));
        for (int i = 0; i < this.numShorDoc; ++i) {
            for (int tIndex = 0; tIndex < this.numTopics; ++tIndex) {
                double pros = ((double)this.shortDocTopicCnts[i][tIndex] + this.alpha) / ((double)this.N_d[i] + (double)this.numTopics * this.alpha);
                writer.write(pros + " ");
            }
            writer.write("\n");
        }
        writer.close();
        writer.close();
    }

    public void writeTopTopicalWords() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".topWords"));
        block0: for (int tIndex = 0; tIndex < this.numTopics; ++tIndex) {
            Map wordCount = new TreeMap<Integer, Integer>();
            for (int wIndex = 0; wIndex < this.vocabularySize; ++wIndex) {
                wordCount.put(wIndex, this.V[wIndex][tIndex]);
            }
            wordCount = FuncUtils.sortByValueDescending(wordCount);
            Set mostLikelyWords = wordCount.keySet();
            int count = 0;
            for (Integer index : mostLikelyWords) {
                if (count < this.topWords) {
                    double pro = ((double)this.V[index][tIndex] + this.beta) / ((double)this.topicCnts[tIndex] + this.betaSum);
                    pro = (double)Math.round(pro * 1000000.0) / 1000000.0;
                    writer.write(this.id2WordVocabulary.get(index) + " ");
                    ++count;
                    continue;
                }
                writer.write("\n");
                continue block0;
            }
        }
        writer.close();
    }

    public void writeTopicWordPros() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".phi"));
        for (int i = 0; i < this.numTopics; ++i) {
            for (int j = 0; j < this.vocabularySize; ++j) {
                double pro = ((double)this.V[j][i] + this.beta) / ((double)this.topicCnts[i] + this.betaSum);
                writer.write(pro + " ");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public void writeParameters() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".paras"));
        writer.write("-model\tPTM");
        writer.write("\n-corpus\t" + this.corpusPath);
        writer.write("\n-ntopics\t" + this.numTopics);
        writer.write("\n-nlongdoc\t" + this.numLongDoc);
        writer.write("\n-alpha\t" + this.alpha);
        writer.write("\n-beta\t" + this.beta);
        writer.write("\n-niters\t" + this.numIterations);
        writer.write("\n-twords\t" + this.topWords);
        writer.write("\n-name\t" + this.expName);
        if (this.tAssignsFilePath.length() > 0) {
            writer.write("\n-initFile\t" + this.tAssignsFilePath);
        }
        if (this.savestep > 0) {
            writer.write("\n-sstep\t" + this.savestep);
        }
        writer.write("\n-initiation time\t" + this.initTime);
        writer.write("\n-one iteration time\t" + this.iterTime / (double)this.numIterations);
        writer.write("\n-total time\t" + (this.initTime + this.iterTime));
        writer.close();
    }

    public void writeDictionary() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".vocabulary"));
        for (int id = 0; id < this.vocabularySize; ++id) {
            writer.write(this.id2WordVocabulary.get(id) + " " + id + "\n");
        }
        writer.close();
    }

    public static void main(String[] args) throws Exception {
        PTM ptm = new PTM("dataset/Tweet.txt", 100, 1000, 0.1, 0.1, 0.01, 2000, 10, "TweetPTM");
        ptm.inference();
    }
}

