/*
 * Decompiled with CFR 0.152.
 */
package models;

import cc.mallet.optimize.InvalidOptimizableException;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.Randoms;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import utility.FuncUtils;
import utility.LBFGS;
import utility.Parallel;
import utility.TopicVectorOptimizer;

public class LFDMM {
    public double alpha;
    public double beta;
    public double betaSum;
    public int numTopics;
    public int topWords;
    public double lambda;
    public int numInitIterations;
    public int numIterations;
    public List<List<Integer>> corpus;
    public List<List<Integer>> topicAssignments;
    public int numDocuments;
    public int numWordsInCorpus;
    public HashMap<String, Integer> word2IdVocabulary;
    public HashMap<Integer, String> id2WordVocabulary;
    public int vocabularySize;
    public int[] docTopicCount;
    public int[][] topicWordCountDMM;
    public int[] sumTopicWordCountDMM;
    public int[][] topicWordCountLF;
    public int[] sumTopicWordCountLF;
    public double[] multiPros;
    public String folderPath;
    public String corpusPath;
    public String vectorFilePath;
    public double[][] wordVectors;
    public double[][] topicVectors;
    public int vectorSize;
    public double[][] dotProductValues;
    public double[][] expDotProductValues;
    public double[] sumExpValues;
    public final double l2Regularizer = 0.01;
    public final double tolerance = 0.05;
    public String expName = "LFDMM";
    public String orgExpName = "LFDMM";
    public String tAssignsFilePath = "";
    public int savestep = 0;
    public double initTime = 0.0;
    public double iterTime = 0.0;

    public LFDMM(String pathToCorpus, String pathToWordVectorsFile, int inNumTopics, double inAlpha, double inBeta, double inLambda, int inNumInitIterations, int inNumIterations, int inTopWords) throws Exception {
        this(pathToCorpus, pathToWordVectorsFile, inNumTopics, inAlpha, inBeta, inLambda, inNumInitIterations, inNumIterations, inTopWords, "LFDMM");
    }

    public LFDMM(String pathToCorpus, String pathToWordVectorsFile, int inNumTopics, double inAlpha, double inBeta, double inLambda, int inNumInitIterations, int inNumIterations, int inTopWords, String inExpName) throws Exception {
        this(pathToCorpus, pathToWordVectorsFile, inNumTopics, inAlpha, inBeta, inLambda, inNumInitIterations, inNumIterations, inTopWords, inExpName, "", 0);
    }

    public LFDMM(String pathToCorpus, String pathToWordVectorsFile, int inNumTopics, double inAlpha, double inBeta, double inLambda, int inNumInitIterations, int inNumIterations, int inTopWords, String inExpName, String pathToTAfile) throws Exception {
        this(pathToCorpus, pathToWordVectorsFile, inNumTopics, inAlpha, inBeta, inLambda, inNumInitIterations, inNumIterations, inTopWords, inExpName, pathToTAfile, 0);
    }

    public LFDMM(String pathToCorpus, String pathToWordVectorsFile, int inNumTopics, double inAlpha, double inBeta, double inLambda, int inNumInitIterations, int inNumIterations, int inTopWords, String inExpName, int inSaveStep) throws Exception {
        this(pathToCorpus, pathToWordVectorsFile, inNumTopics, inAlpha, inBeta, inLambda, inNumInitIterations, inNumIterations, inTopWords, inExpName, "", inSaveStep);
    }

    public LFDMM(String pathToCorpus, String pathToWordVectorsFile, int inNumTopics, double inAlpha, double inBeta, double inLambda, int inNumInitIterations, int inNumIterations, int inTopWords, String inExpName, String pathToTAfile, int inSaveStep) throws Exception {
        this.alpha = inAlpha;
        this.beta = inBeta;
        this.lambda = inLambda;
        this.numTopics = inNumTopics;
        this.numIterations = inNumIterations;
        this.numInitIterations = inNumInitIterations;
        this.topWords = inTopWords;
        this.savestep = inSaveStep;
        this.orgExpName = this.expName = inExpName;
        this.vectorFilePath = pathToWordVectorsFile;
        this.corpusPath = pathToCorpus;
        this.folderPath = "results/";
        File dir = new File(this.folderPath);
        if (!dir.exists()) {
            dir.mkdir();
        }
        System.out.println("Reading topic modeling corpus: " + pathToCorpus);
        this.word2IdVocabulary = new HashMap();
        this.id2WordVocabulary = new HashMap();
        this.corpus = new ArrayList<List<Integer>>();
        this.numDocuments = 0;
        this.numWordsInCorpus = 0;
        BufferedReader br = null;
        try {
            String doc;
            int indexWord = -1;
            br = new BufferedReader(new FileReader(pathToCorpus));
            while ((doc = br.readLine()) != null) {
                if (doc.trim().length() == 0) continue;
                String[] words = doc.trim().split("\\s+");
                ArrayList<Integer> document = new ArrayList<Integer>();
                for (String word : words) {
                    if (this.word2IdVocabulary.containsKey(word)) {
                        document.add(this.word2IdVocabulary.get(word));
                        continue;
                    }
                    this.word2IdVocabulary.put(word, ++indexWord);
                    this.id2WordVocabulary.put(indexWord, word);
                    document.add(indexWord);
                }
                ++this.numDocuments;
                this.numWordsInCorpus += document.size();
                this.corpus.add(document);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.vocabularySize = this.word2IdVocabulary.size();
        this.docTopicCount = new int[this.numTopics];
        this.topicWordCountDMM = new int[this.numTopics][this.vocabularySize];
        this.sumTopicWordCountDMM = new int[this.numTopics];
        this.topicWordCountLF = new int[this.numTopics][this.vocabularySize];
        this.sumTopicWordCountLF = new int[this.numTopics];
        this.multiPros = new double[this.numTopics];
        for (int i = 0; i < this.numTopics; ++i) {
            this.multiPros[i] = 1.0 / (double)this.numTopics;
        }
        this.betaSum = (double)this.vocabularySize * this.beta;
        this.readWordVectorsFile(this.vectorFilePath);
        this.topicVectors = new double[this.numTopics][this.vectorSize];
        this.dotProductValues = new double[this.numTopics][this.vocabularySize];
        this.expDotProductValues = new double[this.numTopics][this.vocabularySize];
        this.sumExpValues = new double[this.numTopics];
        System.out.println("Corpus size: " + this.numDocuments + " docs, " + this.numWordsInCorpus + " words");
        System.out.println("Vocabuary size: " + this.vocabularySize);
        System.out.println("Number of topics: " + this.numTopics);
        System.out.println("alpha: " + this.alpha);
        System.out.println("beta: " + this.beta);
        System.out.println("lambda: " + this.lambda);
        System.out.println("Number of initial sampling iterations: " + this.numInitIterations);
        System.out.println("Number of EM-style sampling iterations for the LF-DMM model: " + this.numIterations);
        System.out.println("Number of top topical words: " + this.topWords);
        long startTime = System.currentTimeMillis();
        this.tAssignsFilePath = pathToTAfile;
        if (this.tAssignsFilePath.length() > 0) {
            this.initialize(this.tAssignsFilePath);
        } else {
            this.initialize();
        }
        this.initTime = System.currentTimeMillis() - startTime;
    }

    public void readWordVectorsFile(String pathToWordVectorsFile) throws Exception {
        System.out.println("Reading word vectors from word-vectors file " + pathToWordVectorsFile + "...");
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(pathToWordVectorsFile));
            String[] elements = br.readLine().trim().split("\\s+");
            this.vectorSize = elements.length - 1;
            this.wordVectors = new double[this.vocabularySize][this.vectorSize];
            String word = elements[0];
            if (this.word2IdVocabulary.containsKey(word)) {
                for (int j = 0; j < this.vectorSize; ++j) {
                    this.wordVectors[this.word2IdVocabulary.get((Object)word).intValue()][j] = new Double(elements[j + 1]);
                }
            }
            while ((line = br.readLine()) != null) {
                elements = line.trim().split("\\s+");
                word = elements[0];
                if (!this.word2IdVocabulary.containsKey(word)) continue;
                for (int j = 0; j < this.vectorSize; ++j) {
                    this.wordVectors[this.word2IdVocabulary.get((Object)word).intValue()][j] = new Double(elements[j + 1]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.vocabularySize; ++i) {
            if (MatrixOps.absNorm(this.wordVectors[i]) != 0.0) continue;
            System.out.println("The word \"" + this.id2WordVocabulary.get(i) + "\" doesn't have a corresponding vector!!!");
        }
    }

    public void initialize() throws IOException {
        System.out.println("Randomly initialzing topic assignments ...");
        this.topicAssignments = new ArrayList<List<Integer>>();
        for (int docId = 0; docId < this.numDocuments; ++docId) {
            int topic;
            ArrayList<Integer> topics = new ArrayList<Integer>();
            int n = topic = FuncUtils.nextDiscrete(this.multiPros);
            this.docTopicCount[n] = this.docTopicCount[n] + 1;
            int docSize = this.corpus.get(docId).size();
            for (int j = 0; j < docSize; ++j) {
                int wordId = this.corpus.get(docId).get(j);
                boolean component = new Randoms().nextBoolean();
                int subtopic = topic;
                if (!component) {
                    int[] nArray = this.topicWordCountLF[topic];
                    int n2 = wordId;
                    nArray[n2] = nArray[n2] + 1;
                    int n3 = topic;
                    this.sumTopicWordCountLF[n3] = this.sumTopicWordCountLF[n3] + 1;
                } else {
                    int[] nArray = this.topicWordCountDMM[topic];
                    int n4 = wordId;
                    nArray[n4] = nArray[n4] + 1;
                    int n5 = topic;
                    this.sumTopicWordCountDMM[n5] = this.sumTopicWordCountDMM[n5] + 1;
                    subtopic += this.numTopics;
                }
                topics.add(subtopic);
            }
            this.topicAssignments.add(topics);
        }
        System.out.println("Initial sampling iteration: ");
        for (int iter = 1; iter <= this.numInitIterations; ++iter) {
            System.out.print("\t" + iter);
            this.sampleSingleInitialIteration();
        }
    }

    public void initialize(String pathToTopicAssignmentFile) throws Exception {
        System.out.println("Reading topic-assignment file: " + pathToTopicAssignmentFile);
        this.topicAssignments = new ArrayList<List<Integer>>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(pathToTopicAssignmentFile));
            int docId = 0;
            int numWords = 0;
            while ((line = br.readLine()) != null) {
                int topic;
                String[] strTopics = line.trim().split("\\s+");
                ArrayList<Integer> topics = new ArrayList<Integer>();
                int n = topic = new Integer(strTopics[0]) % this.numTopics;
                this.docTopicCount[n] = this.docTopicCount[n] + 1;
                for (int j = 0; j < strTopics.length; ++j) {
                    int wordId = this.corpus.get(docId).get(j);
                    int subtopic = new Integer(strTopics[j]);
                    if (subtopic == topic) {
                        int[] nArray = this.topicWordCountLF[topic];
                        int n2 = wordId;
                        nArray[n2] = nArray[n2] + 1;
                        int n3 = topic;
                        this.sumTopicWordCountLF[n3] = this.sumTopicWordCountLF[n3] + 1;
                    } else {
                        int[] nArray = this.topicWordCountDMM[topic];
                        int n4 = wordId;
                        nArray[n4] = nArray[n4] + 1;
                        int n5 = topic;
                        this.sumTopicWordCountDMM[n5] = this.sumTopicWordCountDMM[n5] + 1;
                    }
                    topics.add(subtopic);
                    ++numWords;
                }
                this.topicAssignments.add(topics);
                ++docId;
            }
            if (docId != this.numDocuments || numWords != this.numWordsInCorpus) {
                System.out.println("The topic modeling corpus and topic assignment file are not consistent!!!");
                throw new Exception();
            }
            for (int iter = 1; iter <= this.numInitIterations; ++iter) {
                System.out.println("\tInitial sampling iteration: " + iter);
                this.sampleSingleInitialIteration();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void inference() throws IOException {
        System.out.println("Running Gibbs sampling inference: ");
        long startTime = System.currentTimeMillis();
        for (int iter = 1; iter <= this.numIterations; ++iter) {
            if (iter % 50 == 0) {
                System.out.print(" " + iter);
            }
            this.optimizeTopicVectors();
            this.sampleSingleIteration();
        }
        System.out.println();
        this.iterTime = System.currentTimeMillis() - startTime;
        this.expName = this.orgExpName;
        System.out.println("Writing output from the last sample ...");
        this.write();
        System.out.println("Sampling completed!");
    }

    public void optimizeTopicVectors() {
        System.out.println("\t\tEstimating topic vectors ...");
        this.sumExpValues = new double[this.numTopics];
        this.dotProductValues = new double[this.numTopics][this.vocabularySize];
        this.expDotProductValues = new double[this.numTopics][this.vocabularySize];
        Parallel.loop(this.numTopics, new Parallel.LoopInt(){

            @Override
            public void compute(int topic) {
                int rate = 1;
                boolean check = true;
                while (check) {
                    double l2Value = 0.01 * (double)rate;
                    try {
                        TopicVectorOptimizer optimizer = new TopicVectorOptimizer(LFDMM.this.topicVectors[topic], LFDMM.this.topicWordCountLF[topic], LFDMM.this.wordVectors, l2Value);
                        LBFGS gd = new LBFGS(optimizer, 0.05);
                        gd.optimize(600);
                        optimizer.getParameters(LFDMM.this.topicVectors[topic]);
                        LFDMM.this.sumExpValues[topic] = optimizer.computePartitionFunction(LFDMM.this.dotProductValues[topic], LFDMM.this.expDotProductValues[topic]);
                        check = false;
                        if (LFDMM.this.sumExpValues[topic] == 0.0 || Double.isInfinite(LFDMM.this.sumExpValues[topic])) {
                            int index;
                            double max = -1.0E9;
                            for (index = 0; index < LFDMM.this.vocabularySize; ++index) {
                                if (!(LFDMM.this.dotProductValues[topic][index] > max)) continue;
                                max = LFDMM.this.dotProductValues[topic][index];
                            }
                            for (index = 0; index < LFDMM.this.vocabularySize; ++index) {
                                LFDMM.this.expDotProductValues[topic][index] = Math.exp(LFDMM.this.dotProductValues[topic][index] - max);
                                int n = topic;
                                LFDMM.this.sumExpValues[n] = LFDMM.this.sumExpValues[n] + LFDMM.this.expDotProductValues[topic][index];
                            }
                        }
                    }
                    catch (InvalidOptimizableException e) {
                        e.printStackTrace();
                        check = true;
                    }
                    rate *= 10;
                }
            }
        });
    }

    public void sampleSingleIteration() {
        for (int dIndex = 0; dIndex < this.numDocuments; ++dIndex) {
            int subtopic;
            int word;
            int wIndex;
            List<Integer> document = this.corpus.get(dIndex);
            int docSize = document.size();
            int topic = this.topicAssignments.get(dIndex).get(0) % this.numTopics;
            this.docTopicCount[topic] = this.docTopicCount[topic] - 1;
            for (wIndex = 0; wIndex < docSize; ++wIndex) {
                word = document.get(wIndex);
                subtopic = this.topicAssignments.get(dIndex).get(wIndex);
                if (subtopic == topic) {
                    int[] nArray = this.topicWordCountLF[topic];
                    int n = word;
                    nArray[n] = nArray[n] - 1;
                    int n2 = topic;
                    this.sumTopicWordCountLF[n2] = this.sumTopicWordCountLF[n2] - 1;
                    continue;
                }
                int[] nArray = this.topicWordCountDMM[topic];
                int n = word;
                nArray[n] = nArray[n] - 1;
                int n3 = topic;
                this.sumTopicWordCountDMM[n3] = this.sumTopicWordCountDMM[n3] - 1;
            }
            for (int tIndex = 0; tIndex < this.numTopics; ++tIndex) {
                this.multiPros[tIndex] = (double)this.docTopicCount[tIndex] + this.alpha;
                for (int wIndex2 = 0; wIndex2 < docSize; ++wIndex2) {
                    int word2 = document.get(wIndex2);
                    int n = tIndex;
                    this.multiPros[n] = this.multiPros[n] * (this.lambda * this.expDotProductValues[tIndex][word2] / this.sumExpValues[tIndex] + (1.0 - this.lambda) * ((double)this.topicWordCountDMM[tIndex][word2] + this.beta) / ((double)this.sumTopicWordCountDMM[tIndex] + this.betaSum));
                }
            }
            int n = topic = FuncUtils.nextDiscrete(this.multiPros);
            this.docTopicCount[n] = this.docTopicCount[n] + 1;
            for (wIndex = 0; wIndex < docSize; ++wIndex) {
                word = document.get(wIndex);
                subtopic = topic;
                if (this.lambda * this.expDotProductValues[topic][word] / this.sumExpValues[topic] > (1.0 - this.lambda) * ((double)this.topicWordCountDMM[topic][word] + this.beta) / ((double)this.sumTopicWordCountDMM[topic] + this.betaSum)) {
                    int[] nArray = this.topicWordCountLF[topic];
                    int n4 = word;
                    nArray[n4] = nArray[n4] + 1;
                    int n5 = topic;
                    this.sumTopicWordCountLF[n5] = this.sumTopicWordCountLF[n5] + 1;
                } else {
                    int[] nArray = this.topicWordCountDMM[topic];
                    int n6 = word;
                    nArray[n6] = nArray[n6] + 1;
                    int n7 = topic;
                    this.sumTopicWordCountDMM[n7] = this.sumTopicWordCountDMM[n7] + 1;
                    subtopic += this.numTopics;
                }
                this.topicAssignments.get(dIndex).set(wIndex, subtopic);
            }
        }
    }

    public void sampleSingleInitialIteration() {
        for (int dIndex = 0; dIndex < this.numDocuments; ++dIndex) {
            int subtopic;
            int word;
            int wIndex;
            List<Integer> document = this.corpus.get(dIndex);
            int docSize = document.size();
            int topic = this.topicAssignments.get(dIndex).get(0) % this.numTopics;
            this.docTopicCount[topic] = this.docTopicCount[topic] - 1;
            for (wIndex = 0; wIndex < docSize; ++wIndex) {
                word = document.get(wIndex);
                subtopic = this.topicAssignments.get(dIndex).get(wIndex);
                if (topic == subtopic) {
                    int[] nArray = this.topicWordCountLF[topic];
                    int n = word;
                    nArray[n] = nArray[n] - 1;
                    int n2 = topic;
                    this.sumTopicWordCountLF[n2] = this.sumTopicWordCountLF[n2] - 1;
                    continue;
                }
                int[] nArray = this.topicWordCountDMM[topic];
                int n = word;
                nArray[n] = nArray[n] - 1;
                int n3 = topic;
                this.sumTopicWordCountDMM[n3] = this.sumTopicWordCountDMM[n3] - 1;
            }
            for (int tIndex = 0; tIndex < this.numTopics; ++tIndex) {
                this.multiPros[tIndex] = (double)this.docTopicCount[tIndex] + this.alpha;
                for (int wIndex2 = 0; wIndex2 < docSize; ++wIndex2) {
                    int word2 = document.get(wIndex2);
                    int n = tIndex;
                    this.multiPros[n] = this.multiPros[n] * (this.lambda * ((double)this.topicWordCountLF[tIndex][word2] + this.beta) / ((double)this.sumTopicWordCountLF[tIndex] + this.betaSum) + (1.0 - this.lambda) * ((double)this.topicWordCountDMM[tIndex][word2] + this.beta) / ((double)this.sumTopicWordCountDMM[tIndex] + this.betaSum));
                }
            }
            int n = topic = FuncUtils.nextDiscrete(this.multiPros);
            this.docTopicCount[n] = this.docTopicCount[n] + 1;
            for (wIndex = 0; wIndex < docSize; ++wIndex) {
                word = document.get(wIndex);
                subtopic = topic;
                if (this.lambda * ((double)this.topicWordCountLF[topic][word] + this.beta) / ((double)this.sumTopicWordCountLF[topic] + this.betaSum) > (1.0 - this.lambda) * ((double)this.topicWordCountDMM[topic][word] + this.beta) / ((double)this.sumTopicWordCountDMM[topic] + this.betaSum)) {
                    int[] nArray = this.topicWordCountLF[topic];
                    int n4 = word;
                    nArray[n4] = nArray[n4] + 1;
                    int n5 = topic;
                    this.sumTopicWordCountLF[n5] = this.sumTopicWordCountLF[n5] + 1;
                } else {
                    int[] nArray = this.topicWordCountDMM[topic];
                    int n6 = word;
                    nArray[n6] = nArray[n6] + 1;
                    int n7 = topic;
                    this.sumTopicWordCountDMM[n7] = this.sumTopicWordCountDMM[n7] + 1;
                    subtopic += this.numTopics;
                }
                this.topicAssignments.get(dIndex).set(wIndex, subtopic);
            }
        }
    }

    public void writeParameters() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".paras"));
        writer.write("-model\tLFDMM");
        writer.write("\n-corpus\t" + this.corpusPath);
        writer.write("\n-vectors\t" + this.vectorFilePath);
        writer.write("\n-ntopics\t" + this.numTopics);
        writer.write("\n-alpha\t" + this.alpha);
        writer.write("\n-beta\t" + this.beta);
        writer.write("\n-lambda\t" + this.lambda);
        writer.write("\n-initers\t" + this.numInitIterations);
        writer.write("\n-niters\t" + this.numIterations);
        writer.write("\n-twords\t" + this.topWords);
        writer.write("\n-name\t" + this.expName);
        if (this.tAssignsFilePath.length() > 0) {
            writer.write("\n-initFile\t" + this.tAssignsFilePath);
        }
        if (this.savestep > 0) {
            writer.write("\n-sstep\t" + this.savestep);
        }
        writer.write("\n-initiation time\t" + this.initTime);
        writer.write("\n-one iteration time\t" + this.iterTime / (double)this.numIterations);
        writer.write("\n-total time\t" + (this.initTime + this.iterTime));
        writer.close();
    }

    public void writeDictionary() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".vocabulary"));
        for (String word : this.word2IdVocabulary.keySet()) {
            writer.write(word + " " + this.word2IdVocabulary.get(word) + "\n");
        }
        writer.close();
    }

    public void writeIDbasedCorpus() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".IDcorpus"));
        for (int dIndex = 0; dIndex < this.numDocuments; ++dIndex) {
            int docSize = this.corpus.get(dIndex).size();
            for (int wIndex = 0; wIndex < docSize; ++wIndex) {
                writer.write(this.corpus.get(dIndex).get(wIndex) + " ");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public void writeTopicAssignments() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".topicAssignments"));
        for (int dIndex = 0; dIndex < this.numDocuments; ++dIndex) {
            int docSize = this.corpus.get(dIndex).size();
            for (int wIndex = 0; wIndex < docSize; ++wIndex) {
                writer.write(this.topicAssignments.get(dIndex).get(wIndex) + " ");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public void writeTopicVectors() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".topicVectors"));
        for (int i = 0; i < this.numTopics; ++i) {
            for (int j = 0; j < this.vectorSize; ++j) {
                writer.write(this.topicVectors[i][j] + " ");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public void writeTopTopicalWords() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".topWords"));
        block0: for (int tIndex = 0; tIndex < this.numTopics; ++tIndex) {
            Map<Integer, Double> topicWordProbs = new TreeMap();
            for (int wIndex = 0; wIndex < this.vocabularySize; ++wIndex) {
                double pro = this.lambda * this.expDotProductValues[tIndex][wIndex] / this.sumExpValues[tIndex] + (1.0 - this.lambda) * ((double)this.topicWordCountDMM[tIndex][wIndex] + this.beta) / ((double)this.sumTopicWordCountDMM[tIndex] + this.betaSum);
                topicWordProbs.put(wIndex, pro);
            }
            topicWordProbs = FuncUtils.sortByValueDescending(topicWordProbs);
            Set mostLikelyWords = topicWordProbs.keySet();
            int count = 0;
            for (Integer index : mostLikelyWords) {
                if (count < this.topWords) {
                    writer.write(this.id2WordVocabulary.get(index) + " ");
                    ++count;
                    continue;
                }
                writer.write("\n");
                continue block0;
            }
        }
        writer.close();
    }

    public void writeTopicWordPros() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".phi"));
        for (int t = 0; t < this.numTopics; ++t) {
            for (int w = 0; w < this.vocabularySize; ++w) {
                double pro = this.lambda * this.expDotProductValues[t][w] / this.sumExpValues[t] + (1.0 - this.lambda) * ((double)this.topicWordCountDMM[t][w] + this.beta) / ((double)this.sumTopicWordCountDMM[t] + this.betaSum);
                writer.write(pro + " ");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public void writeDocTopicPros() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".theta"));
        for (int i = 0; i < this.numDocuments; ++i) {
            int tIndex;
            int docSize = this.corpus.get(i).size();
            double sum = 0.0;
            for (tIndex = 0; tIndex < this.numTopics; ++tIndex) {
                this.multiPros[tIndex] = (double)this.docTopicCount[tIndex] + this.alpha;
                for (int wIndex = 0; wIndex < docSize; ++wIndex) {
                    int word = this.corpus.get(i).get(wIndex);
                    int n = tIndex;
                    this.multiPros[n] = this.multiPros[n] * (this.lambda * this.expDotProductValues[tIndex][word] / this.sumExpValues[tIndex] + (1.0 - this.lambda) * ((double)this.topicWordCountDMM[tIndex][word] + this.beta) / ((double)this.sumTopicWordCountDMM[tIndex] + this.betaSum));
                }
                sum += this.multiPros[tIndex];
            }
            for (tIndex = 0; tIndex < this.numTopics; ++tIndex) {
                writer.write(this.multiPros[tIndex] / sum + " ");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public void write() throws IOException {
        this.writeTopTopicalWords();
        this.writeDocTopicPros();
        this.writeTopicAssignments();
        this.writeTopicWordPros();
        this.writeParameters();
    }

    public static void main(String[] args) throws Exception {
        LFDMM lfdmm = new LFDMM("dataset/Pascal_Flickr.txt", "dataset/glove.6B.200d.txt", 20, 0.1, 0.01, 0.6, 50, 500, 10, "Pascal_FlickrLFDMM");
        lfdmm.writeParameters();
        lfdmm.inference();
    }
}

