/*
 * Decompiled with CFR 0.152.
 */
package eval;

import de.bwaldvogel.liblinear.Train;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import utility.FuncUtils;

public class ClassificationEval {
    String pathDocTopicProsFile;
    String pathGoldenLabelsFile;
    ArrayList<String> goldenLabel;
    HashMap<String, Integer> goldenClusers;
    ArrayList<ArrayList<String>> docTopicProb;
    int numDocs;

    public ClassificationEval(String inPathGoldenLabelsFile, String inPathDocTopicProsFile) throws Exception {
        this.pathDocTopicProsFile = inPathDocTopicProsFile;
        this.pathGoldenLabelsFile = inPathGoldenLabelsFile;
        this.goldenLabel = new ArrayList();
        this.goldenClusers = new HashMap();
        this.docTopicProb = new ArrayList();
        this.readGoldenLabelsFile();
        this.readDocTopicProsFile();
        this.numDocs = 0;
    }

    public void readGoldenLabelsFile() throws Exception {
        System.out.println("Reading golden labels file " + this.pathGoldenLabelsFile);
        BufferedReader br = null;
        try {
            String label;
            int ind = -1;
            br = new BufferedReader(new FileReader(this.pathGoldenLabelsFile));
            while ((label = br.readLine()) != null) {
                if (this.goldenClusers.containsKey(label = label.trim())) {
                    ind = this.goldenClusers.get(label);
                } else {
                    this.goldenClusers.put(label, ++ind);
                }
                this.goldenLabel.add(label);
                ++this.numDocs;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readDocTopicProsFile() throws Exception {
        System.out.println("Reading document-to-topic distribution file " + this.pathDocTopicProsFile);
        HashMap docLabelOutput = new HashMap();
        int docIndex = 0;
        BufferedReader br = null;
        try {
            String docTopicProbs;
            br = new BufferedReader(new FileReader(this.pathDocTopicProsFile));
            while ((docTopicProbs = br.readLine()) != null) {
                String[] pros = docTopicProbs.trim().split("\\s+");
                ArrayList<String> oneText = new ArrayList<String>();
                for (int topicIndex = 0; topicIndex < pros.length; ++topicIndex) {
                    oneText.add(pros[topicIndex]);
                }
                this.docTopicProb.add(oneText);
                ++docIndex;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.numDocs != docIndex) {
            System.out.println("Error: the number of documents is different to the number of labels!");
            throw new Exception();
        }
    }

    public void writeNewDocTopicPros() throws IOException {
        String folderPath = "results/";
        File dir = new File(folderPath);
        if (!dir.exists()) {
            dir.mkdir();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(folderPath + "theta.temp"));
        for (int i = 0; i < this.docTopicProb.size(); ++i) {
            writer.write(this.goldenClusers.get(this.goldenLabel.get(i)) + " ");
            for (int j = 0; j < this.docTopicProb.get(i).size(); ++j) {
                int index = j + 1;
                writer.write(index + ":" + this.docTopicProb.get(i).get(j) + " ");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public static void evaluate(String pathGoldenLabelsFile, String pathToFolderOfDocTopicProsFiles, String suffix) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(pathToFolderOfDocTopicProsFiles + "/" + suffix + ".accuracy"));
        writer.write("Golden-labels in: " + pathGoldenLabelsFile + "\n\n");
        File[] files = new File(pathToFolderOfDocTopicProsFiles).listFiles();
        ArrayList<Double> accuracy = new ArrayList<Double>();
        for (File file : files) {
            if (!file.getName().endsWith(suffix)) continue;
            writer.write("Results for: " + file.getAbsolutePath() + "\n");
            ClassificationEval dce = new ClassificationEval(pathGoldenLabelsFile, file.getAbsolutePath());
            dce.writeNewDocTopicPros();
            String[] param = new String[]{"-v", "5", "-s", "2", "results/theta.temp"};
            double value = new Train().run(param);
            writer.write("\tAccuracy: " + value + "\n");
            accuracy.add(value);
        }
        if (accuracy.size() == 0) {
            System.out.println("Error: There is no file ending with " + suffix);
            throw new Exception();
        }
        double[] coherenceValues = new double[accuracy.size()];
        for (int i = 0; i < accuracy.size(); ++i) {
            coherenceValues[i] = (Double)accuracy.get(i);
        }
        writer.write("\n---\nMean accuracy: " + FuncUtils.mean(coherenceValues) + ", standard deviation: " + FuncUtils.stddev(coherenceValues));
        System.out.println("---\nMean accuracy: " + FuncUtils.mean(coherenceValues) + ", standard deviation: " + FuncUtils.stddev(coherenceValues));
        writer.close();
    }

    public static void main(String[] args) throws Exception {
        ClassificationEval.evaluate("dataset/SearchSnippets_LABEL.txt", "results", "theta");
    }
}

