import time

from autogluon_utils.sandbox.auto_pilot.auto_pilot_utils import get_isengard_session


def create_image(name, instance_id=None, session=None):
    if session is None:
        session = get_isengard_session()

    ec2 = session.client("ec2")

    time_start = time.time()
    description = ec2.describe_images(
        Filters=[
            {
                'Name': 'name',
                'Values': [
                    name,
                ]
            },
        ],
    )
    if not description['Images']:
        print(f'Creating image {name} from instance_id {instance_id}...')
        if instance_id is None:
            raise AssertionError('instance_id must be specified if creating a new image!')
        ec2.create_image(InstanceId=instance_id, Name=name)
    else:
        print('Image already exists!')
    print(f'Waiting for image {name} to be available...')
    waiter = ec2.get_waiter('image_available')
    waiter.wait(
        Filters=[
            {
                'Name': 'name',
                'Values': [
                    name,
                ]
            },
        ],
    )
    time_end = time.time()
    print('Image is available. Time:', time_end - time_start)

    description = ec2.describe_images(
        Filters=[
            {
                'Name': 'name',
                'Values': [
                    name,
                ]
            },
        ],
    )

    image_id = description['Images'][0]['ImageId']

    print(f'Image Id: {image_id}')

    return image_id
