""" Prepare instances for distillation benchmarking """

from ..instance_config.instance_benchmark_config import InstanceBenchmarkConfig

# Path to run_trial script on EC2 instance:
PATH_TO_RUN_TRIAL = '/home/ubuntu/autogluon-utils/autogluon_utils/scripts/distillbenchmark/run_distill_trial.sh'

def get_configs(datasets: list, profiles: list, methods, tag: str = None) -> list:
    """ methods should be str, can be str that represents a list of methods. Tag is optional str. """
    base_command = PATH_TO_RUN_TRIAL
    configs = []
    if len(methods) == 1:
        methods = methods[0]  # extract as str
    if not isinstance(methods, str):
        methods_str_name = "_".join([str(m) for m in methods])
        methods_str_cmd = '['+','.join(methods)+']'
    else:
        methods_str_name = methods
        methods_str_cmd = methods
    for dataset in datasets:
        for profile in profiles:
            name_suffix = '_' + dataset + '_' + profile + '_' + methods_str_name
            run_command = base_command + " " + dataset + " " + profile + " " + methods_str_cmd
            if tag is not None:
                run_command = run_command + " " + tag
            config = InstanceBenchmarkConfig(name_suffix=name_suffix, run_command=run_command)
            configs.append(config)
    return configs
