import tensorflow as tf
from tensorflow import keras, random
from tensorflow.keras import initializers
import numpy as np
import matplotlib.pyplot as plt
import pickle

np.random.seed(123)
tf.random.set_seed(456)

#Define the nonlinear activation function
c=np.sqrt(0.21747/(2*np.sqrt(2*np.pi)))
def activ_function(x):
  return (keras.backend.sigmoid(x)-0.5)/c
def dactiv_function(x):
  return np.exp(-x)/(((1+np.exp(-x))**2)*c)

#Setting parameters
sample_dim=1000
test_sample_dim=500
input_dim=800
weight_dim=800
learning_rate = 0.01
batch=32
epoch=300
t_n=1.0/np.sqrt(weight_dim)
L=3

#Generate the training and test data
v=np.random.normal(size=(1,input_dim))
v=np.sqrt(input_dim)*v/np.linalg.norm(v)
def f_aim(x):
  return activ_function(np.inner(v,x))
train_data = np.random.normal(size=(sample_dim, input_dim))
train_data=train_data-train_data.mean(axis=0)
train_data=train_data/train_data.std(axis=0)/np.sqrt(input_dim)
train_labels = np.array(list(map(f_aim, train_data)))
test_data = np.random.normal(size=(test_sample_dim, input_dim))
test_data=test_data-test_data.mean(axis=0)
test_data=test_data/test_data.std(axis=0)/np.sqrt(input_dim)
test_labels=np.array(list(map(f_aim, test_data)))

#Create the model
inputs=tf.keras.Input(shape=(input_dim,))
x_10=tf.keras.layers.Dense(weight_dim,activation=activ_function,use_bias=False,kernel_initializer=initializers.RandomNormal(mean=0.0,stddev=1.0))(inputs)
x_1=keras.layers.Lambda(lambda x: x*t_n)(x_10)
layer_1=keras.models.Model(inputs, x_1, name="first_layer")
x_20=tf.keras.layers.Dense(weight_dim,activation=activ_function,use_bias=False,kernel_initializer=initializers.RandomNormal(mean=0.0,stddev=1.0))(x_1)
x_2=keras.layers.Lambda(lambda x: x*t_n)(x_20)
layer_2=keras.models.Model(inputs, x_2, name="second_layer")
x_30=tf.keras.layers.Dense(weight_dim,activation=activ_function,use_bias=False,kernel_initializer=initializers.RandomNormal(mean=0.0,stddev=1.0))(x_2)
x_3=keras.layers.Lambda(lambda x: x*t_n)(x_30)
layer_3=keras.models.Model(inputs, x_3, name="third_layer")
outputs=tf.keras.layers.Dense(1,use_bias=False,kernel_initializer=initializers.RandomNormal(mean=0.0,stddev=1.0))(x_3)
model=tf.keras.Model(inputs=inputs,outputs=outputs)
model.summary(line_length=None,positions=None,print_fn=None)
optimizer=tf.keras.optimizers.Adam(learning_rate)
model.compile(optimizer=optimizer,loss='mean_squared_error',metrics=['mean_squared_error'])

X_0=train_data
Y_0=train_labels
X_1=[]
X_2=[]
X_3=[]
X_1.append(layer_1.predict(train_data))
X_2.append(layer_2.predict(train_data))
X_3.append(layer_3.predict(train_data))
Ws=[]
class MyCallback(keras.callbacks.Callback):
  def on_epoch_end(self, epoch, logs={}):
   X_1.append(layer_1.predict(train_data))
   X_2.append(layer_2.predict(train_data))
   X_3.append(layer_3.predict(train_data))
   Ws.append(model.get_weights())
callback = MyCallback()
history=model.fit(train_data, train_labels, epochs=epoch, batch_size=batch,verbose=False, validation_data=(test_data,test_labels),callbacks=[callback])

# Plot the training and test error
plt.plot(history.history['loss'])
plt.plot(history.history['val_loss'])
plt.title('Training and test losses')
plt.ylabel('loss')
plt.xlabel('epoch')
plt.legend(['train', 'test'], loc='upper left')
plt.savefig('training_loss.png')
predictions = model.predict(test_data,verbose=0)
SSerr = sum((test_labels-predictions)**2)
SStot = sum((test_labels-np.mean(test_labels))**2)
Rsq = 1-SSerr/SStot
print('Prediction R^2:', Rsq)
print('Training loss:', history.history['loss'][-1])

pickle.dump(Ws,open('W.pkl','wb'))
X=[X_0,X_1,X_2,X_3]
pickle.dump(X,open('X.pkl','wb'))
data = {'train_data':train_data,'train_labels':train_labels,'test_data':test_data,'test_labels':test_labels}
pickle.dump(data,open('data.pkl','wb'))

