import torch
import matplotlib
import matplotlib.pyplot as plt
import numpy as np
import imageio

def plot_gif(before_project, after_project, arrow, name = '0'):
    def generate_one_frame(data, pred, arrow, xy_max = 3):

        fig, ax = plt.subplots(figsize=(10,10))

        X, Y, U, V = zip(*[arrow])
        ax.quiver(X, Y, U, V, angles='xy', scale_units='xy', scale=1)

        ax.scatter(data[:,0], data[:,1], c = 'y')
        ax.scatter(pred[:,0], pred[:,1], c = 'b')       
        ax.grid()
        ax.set(xlabel='X', ylabel='Y', title='yellow: points before projection; blue: after projection.')
        ax.set_xlim(-xy_max, xy_max)
        ax.set_ylim(-xy_max, xy_max)
        fig.canvas.draw()     

        image = np.frombuffer(fig.canvas.tostring_rgb(), dtype='uint8')
        image  = image.reshape(fig.canvas.get_width_height()[::-1] + (3,))
        
        return image
    
    imageio.mimsave('./visulization_' + name + '.gif', [
        generate_one_frame(before_project[i], after_project[i], arrow[i]) 
        for i in range(len(before_project))
        ], fps=10)

class Proj():
    def __init__(self):
        model_path = '2models/checkpoint _600.pt'
        self.model = torch.load(model_path).cpu()
        print(self.model.iter)
    def project(self, data):
        d = torch.Tensor(data[None, :, :])
        pred = self.model(d)
        pred = pred[0,:,:]
        return pred.detach().numpy()

def test():
    data = np.array([[ 0.2514-1,  0.1707],
        [ 0.0483-1, -0.4097],
        [-0.3870-1,  0.0387],
        [-0.4260-1, -0.4451]])
    force = lambda t: np.array([np.sin(t*2)*5, 20])
    g = np.array([0, -5]) 
    vel = np.array(data)*0
    timestamp = 0.1
    data_list = []
    proj_list = []
    force_list = []
    pr = Proj()
    for ite in range(50):
        new_data = np.array(data)
        
        f_0 = force(ite * timestamp)
        
        
        vel[0, :] += f_0 * timestamp
        
        for i in range (len(data)):
            vel[i, :] += g * timestamp
            new_data[i, :] = data[i,:] + vel[i,:] * timestamp   

        data_list.append(np.array(new_data))
        force_list.append(np.array([new_data[0,0], new_data[0,1], f_0[0]/10, f_0[1]/10]))

        new_data = pr.project(new_data)
        proj_list.append(np.array(new_data))
        
        for i in range (len(data)):
            vel[i,:] = (new_data[i,:] - data[i,:]) / timestamp
        data = (np.array(new_data))

    plot_gif(data_list, proj_list, force_list, 'iter2')



def test2():
    data = np.array([[ 0.2514-1,  0.1707],
        [ 0.0483-1, -0.4097],
        [-0.3870-1,  0.0387],
        [-0.4260-1, -0.4451]])
    force = lambda t: np.array([np.sin(t*2)*5, 20])
    g = np.array([0, -5]) 
    vel = np.array(data)*0
    timestamp = 0.1
    data_list = []
    proj_list = []
    force_list = []
    pr = Proj()
    for ite in range(50):
        new_data = np.array(data)
        
        f_0 = force(ite * timestamp)
        
        
        vel[0, :] += f_0 * timestamp
        
        for i in range (len(data)):
            vel[i, :] += g * timestamp
            new_data[i, :] = data[i,:] + vel[i,:] * timestamp   

        data_list.append(np.array(new_data))
        force_list.append(np.array([new_data[0,0], new_data[0,1], f_0[0]/10, f_0[1]/10]))

        new_data = manual_proj(new_data)
        proj_list.append(np.array(new_data))
        
        for i in range (len(data)):
            vel[i,:] = (new_data[i,:] - data[i,:]) / timestamp
        data = (np.array(new_data))

    plot_gif(data_list, proj_list, force_list, 'iter2')

if __name__ == '__main__':
    test()
    # test2()