# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Computing single H matrix in AICc-function using the Mahalanobis distance
#'
#' @param X matrix with "covariates"
#' @param mcov covariance matrix
#' @param S_scale_dist logical indicating whether the Mahalanobis distance should be scaled with the number of variables
#' @param h numeric specifying the scaling (sigma)
#'
#' @export
#'
#' @return Matrix of dimension \code{ncol(X)*ncol(X)}
#' @author Martin Jullum
hat_matrix_cpp <- function(X, mcov, S_scale_dist, h) {
    .Call(`_shapr_hat_matrix_cpp`, X, mcov, S_scale_dist, h)
}

#' sigma_hat_sq-function
#'
#' @param H Matrix. Output from \code{\link{hat_matrix_cpp}}
#' @param y Vector, i.e. representing the response variable
#'
#' @export
#'
#' @return Scalar
#'
#' @author Martin Jullum
rss_cpp <- function(H, y) {
    .Call(`_shapr_rss_cpp`, H, y)
}

#' correction term with trace_input in AICc formula
#'
#' @param tr_H numeric giving the trace of H
#' @param n numeric given the number of rows in H
#' @export
#'
#' @return Scalar
#' @author Martin Jullum
correction_matrix_cpp <- function(tr_H, n) {
    .Call(`_shapr_correction_matrix_cpp`, tr_H, n)
}

#'  Temp-function for computing the full AICc with several X's etc
#'
#' @param X matrix with "covariates"
#' @param mcov covariance matrix
#' @param S_scale_dist logical indicating whether the Mahalanobis distance should be scaled with the number of variables
#' @param h numeric specifying the scaling (sigma)
#' @param y vector with the "response variable"
#'
#' @export
#'
#' @return Scalar with the numeric value of the AICc formula
#' @author Martin Jullum
aicc_full_single_cpp <- function(X, mcov, S_scale_dist, h, y) {
    .Call(`_shapr_aicc_full_single_cpp`, X, mcov, S_scale_dist, h, y)
}

#'  AICc formula for several sets, alternative definition
#'
#' @param h Numeric. Specifies the scaling (sigma)
#' @param X_list List
#' @param mcov_list List
#' @param S_scale_dist Logical. Indicates whether Mahalanobis distance should be scaled with the
#' number of variables
#' @param y_list List.
#' @param negative Logical.
#'
#' @return Scalar with the numeric value of the AICc formula
#'
#' @author Martin Jullum
aicc_full_cpp <- function(h, X_list, mcov_list, S_scale_dist, y_list, negative) {
    .Call(`_shapr_aicc_full_cpp`, h, X_list, mcov_list, S_scale_dist, y_list, negative)
}

#' (Generalized) Mahalanobis distance
#'
#' Used to get the Euclidean distance as well by setting \code{mcov} = \code{diag(m)}.
#'
#' @param featureList List of vectors indicating all factor combinations that should be included in the computations. Assumes that the first one is empty.
#' @param mcov Matrix. The Sigma-matrix in the Mahalanobis distance formula (\code{stats::cov(Xtrain_mat)}) gives Mahalanobis distance,
#' \code{diag(m)} gives the Euclidean distance.
#' @param S_scale_dist Logical indicating
#' @param Xtrain_mat Matrix
#' @param Xtest_mat Matrix
#'
#' @export
#'
#' @return Array of three dimensions. Contains the squared distance for between all training and test observations for all feature combinations passed to the function.
#' @author Martin Jullum
mahalanobis_distance_cpp <- function(featureList, Xtrain_mat, Xtest_mat, mcov, S_scale_dist) {
    .Call(`_shapr_mahalanobis_distance_cpp`, featureList, Xtrain_mat, Xtest_mat, mcov, S_scale_dist)
}

#' @keywords internal
sample_features_cpp <- function(m, n_features) {
    .Call(`_shapr_sample_features_cpp`, m, n_features)
}

#' Get imputed data
#'
#' @param index_xtrain Positive integer. Represents a sequence of row indices from \code{xtrain},
#' i.e. \code{min(index_xtrain) >= 1} and \code{max(index_xtrain) <= nrow(xtrain)}.
#'
#' @param index_s Positive integer. Represents a sequence of row indices from \code{S},
#' i.e. \code{min(index_s) >= 1} and \code{max(index_s) <= nrow(S)}.
#'
#' @param xtrain Numeric matrix.
#'
#' @param xtest Numeric matrix. Represents a single test observation.
#'
#' @param S Integer matrix of dimension \code{n_combinations x m}, where \code{n_combinations} equals
#' the total number of sampled/non-sampled feature combinations and \code{m} equals
#' the total number of unique features. Note that \code{m = ncol(xtrain)}. See details
#' for more information.
#'
#' @details \code{S(i, j) = 1} if and only if feature \code{j} is present in feature
#' combination \code{i}, otherwise \code{S(i, j) = 0}. I.e. if \code{m = 3}, there
#' are \code{2^3 = 8} unique ways to combine the features. In this case \code{dim(S) = c(8, 3)}.
#' Let's call the features \code{x1, x2, x3} and take a closer look at the combination
#' represented by \code{s = c(x1, x2)}. If this combination is represented by the second row,
#' the following is true: \code{S[2, 1:3] = c(1, 1, 0)}.
#'
#' The returned object, \code{X}, is a numeric matrix where
#' \code{dim(X) = c(length(index_xtrain), ncol(xtrain))}. If feature \code{j} is present in
#' the k-th observation, that is \code{S[index_[k], j] == 1}, \code{X[k, j] = xtest[1, j]}.
#' Otherwise \code{X[k, j] = xtrain[index_xtrain[k], j]}.
#'
#' @export
#'
#' @return Numeric matrix
#'
#' @author Nikolai Sellereite
observation_impute_cpp <- function(index_xtrain, index_s, xtrain, xtest, S) {
    .Call(`_shapr_observation_impute_cpp`, index_xtrain, index_s, xtrain, xtest, S)
}

#' Calculate weight matrix
#'
#' @param features List. Each of the elements equals an integer
#' vector representing a valid combination of features.
#' @param m Integer. Number of features
#' @param n Integer. Number of combinations
#' @param w Numeric vector of length \code{n}, i.e. \code{w[i]} equals
#' the shapley weight of feature combination \code{i}, represented by
#' \code{features[[i]]}.
#'
#' @export
#'
#' @return Matrix of dimension n x m + 1
#' @author Nikolai Sellereite
weight_matrix_cpp <- function(features, m, n, w) {
    .Call(`_shapr_weight_matrix_cpp`, features, m, n, w)
}

#' Get feature matrix
#'
#' @param features List
#' @param m Positive integer. Total number of features
#'
#' @export
#'
#' @return Matrix
#' @author Nikolai Sellereite
feature_matrix_cpp <- function(features, m) {
    .Call(`_shapr_feature_matrix_cpp`, features, m)
}

