%%
% Fig 5 in Sec 3.2
% Generalization for small scaled effect f_1
% Test for f_1,eps does not satisfy Cond 1&2
% An explicit expression of invariant distribution does not apply
% But stochasticity, mixing and ergodicity stands
% f_0=x^2/2
% f_1,eps=epsilon*cos((1+cos(xSpan*sqrt(3))/5)
%%
epsilon=0.0001;

%xSpan=[-2:epsilon*0.01:2];
% plot(xSpan,-epsilon*cos((1+cos(xSpan*sqrt(3))/5).*xSpan/epsilon));    % this is f1

h=0.1;
xIC=[-0.9:0.0001:-0.4];         % distribution of initial ensemble
TimeSteps=10000;

%%
x=xIC;
orbit=zeros(1,TimeSteps+1);
orbit_1(1)=x(1);
orbit_2(1)=x(length(x));        % initial conditions of two illustrative orbits
for i=1:TimeSteps
    % strongly convex f0, nonperiodic f1 (also doesn't satisfy cond 1&2)
    x=x-h*(x + sin((1+cos(x*sqrt(3))/5).*x/epsilon)/5.*(5+cos(sqrt(3)*x)-sqrt(3)*x.*sin(sqrt(3)*x)) );  %evolve the ensemble according to GD
    orbit_1(i+1)=x(1);          
    orbit_2(i+1)=x(length(x));  % save the orbits
end

%% plot the results
bins=[-0.8:0.05:0.8];

figure
histogram(xIC,bins,'Normalization','pdf');
hold on
histogram(x,bins,'Normalization','pdf');
set(gca,'FontSize',24);
title(['\fontsize{32}hist of ensemble at final time (#iter',num2str(TimeSteps),')']);
legend('initial distri.',['@ iteration #',num2str(TimeSteps)]);
xlabel('x')
ylabel('pdf')
set(gcf,'Position',[400 300 800 600]);

figure
histogram(orbit_1,bins,'Normalization','pdf');
hold on;
histogram(orbit_2,bins,'Normalization','pdf');
set(gca,'FontSize',24);
title(['\fontsize{32}hist of one orbit over time (IC=',num2str(orbit_1(1)),',',num2str(orbit_2(1)),')']);
legend(['IC=',num2str(orbit_1(1))],['IC=',num2str(orbit_2(1))]);
xlabel('x')
ylabel('pdf')
set(gcf,'Position',[400 300 800 600]);

figure
plot(1:length(orbit_1),orbit_1);
set(gca,'FontSize',24);
title(['\fontsize{32}one orbit (IC=',num2str(orbit_1(1)),')']);
xlabel('# of iteration');
ylabel('x');
xlim([0,TimeSteps])
set(gcf,'Position',[400 300 800 600]);





