# Supplement for Deep Structural Causal Models for Tractable Counterfactual Inference

The appendix can be found in `Supplement_Deep_Structural_Causal_Models_for_Tractable_Counterfactual_Inference.pdf`

## Structure
- `code/`: contains the code used for running the experiments
    - `arch`: model architectures used in experiments
    - `datasets`: datasets used in experiments
    - `distributions`: implementations of useful distributions or transformations
    - `experiments`: implementation of experiments
    - `morphomnist`: soft link to morphomnist tools in submodules
    - `submodules`: git submodules
- `data/`:
    - `morphomnist`: used synthetic morphomnist dataset
    - `ukbb`: subset of the ukbb testset that was used for the counterfactuals 
- `models/`: checkpoints of the trained models
- `plotting/`: notebooks used for plotting

## Requirements
We use Python 3.6.8 for all experiments and show the used libraries in `requirements.txt`.

## Usage

For all code to run you need to add the `code` directory to the `$PYTHONPATH`. We assume the the code is run from inside `code/`.

### Morpho-MNIST

You can recreate the data using the data creation script as:
```
python datasets/morphomnist/create_synth_thickness_intensity_data.py --data-dir /path/to/mnist -o /path/to/dataset
```
or use the provided data in `data/morphomnist`. You can then train the models as:
```
python experiments/morphomnist/trainer.py -e SVIExperiment -m {IndependentVISEM, ConditionalDecoderVISEM, ConditionalVISEM} --data_dir /path/to/data --default_root_dir /path/to/checkpoints --decoder_type fixed_var {--gpus 0}
```
where `IndependentVISEM` is the independent model, `ConditionalDecoderVISEM` is the conditional model and `ConditionalVISEM` is the full model. The checkpoints are saved in `/path/to/checkpoints` or the provided checkpoints can be used for testing and plotting:
```
python experiments/morphomnist/tester.py -c /path/to/checkpoint/version_?
```
and then use the notebook in `plotting` for plotting.

### UKBB

We are unable to share the UKBB dataset. However given a subset you can then train the models as:
```
python experiments/medical/trainer.py -e SVIExperiment -m ConditionalVISEM --default_root_dir /path/to/checkpoints --downsample 3 --decoder_type fixed_var --train_batch_size 256 {--gpus 0}
```
The checkpoints are saved in `/path/to/checkpoints` or the provided checkpoints can be used for testing and plotting:
```
python experiments/medical/tester.py -c /path/to/checkpoint/version_?
```
and then use the notebook in `plotting` for plotting.