pathtoroot=pwd;
cd(pathtoroot)
dataset=5;
%Assuming you have libsvmread downloaded ( https://github.com/cjlin1/libsvm ) and installed/compiled 
%Assuming you have the following folder stucture
% ThisFolder 
%        /chemotherapy/
%        /news20/
%        /rcv1/
%        /webspam/
%        /gisette/
%        /real-sim/
% containing the according datasets from
% https://www.openml.org/d/1085 (chemotherapy)
% https://www.csie.ntu.edu.tw/~cjlin/libsvmtools/datasets/binary.html (all
% others)
if dataset==0
A=csvread([pathtoroot,'/chemotherapy/phpCLGrjq.csv'],2,1); %Ignoring First Row (Letters only) here
disp('Finished loading data ')
b=double(A(:,end)==2); %Extract Labels
b(b==0)=-1; %Change to Labels to -1, +1
A(:,end)=ones(size(A,1),1); %Overwrite Labels with intercept
options.Atest=sparse(0,size(A,2));
options.btest=zeros(0,1);
Datasetname='chemotherapy';
options.L=svds(A,1)^2/(4*size(A,1));

elseif dataset==1
[b,A]=libsvmread([pathtoroot,'/news20/news20.binary']);
A=[ones(size(A,1),1),A]; %Introduce intercept
options.Atest=sparse(0,size(A,2));
options.btest=zeros(0,1);
Datasetname='news20';
options.L=svds(A,1)^2/(4*size(A,1));

elseif dataset==2
[b,A]=libsvmread([pathtoroot,'/rcv1/rcv1_train.binary']);
A=[ones(size(A,1),1),A];
[options.btest,options.Atest]=libsvmread([pathtoroot,'/rcv1/rcv1_test.binary']);
options.Atest=[ones(size(options.Atest,1),1),options.Atest];
Datasetname='rcv1';
options.L=svds(A,1)^2/(4*size(A,1));

elseif dataset==3
 % webspam_wc_normalized_trigram dataset
 %The original dataset [b, A] was loaded with libsvmread and then modified 
 %in advance as follows:
 %Introduced  Intercept: A=[ones(size(A,1),A]; 
 %Removed zero features: original_position=any(A,1); A=A(:,original_position);
 % 
 %The original dataset may be recovered from the included vector original_position
clear A b; 
load([pathtoroot,'/webspam/webspam_wc_normalized_trigram_introduced_intercept_zero_features_removed.mat']);
Datasetname='webspam-trigram';
options.Atest=sparse(0,size(A,2));
options.btest=zeros(0,1);
options.L=(6.852743002095405e+02)^2/(4*size(A,1)); %computed beforehand
elseif dataset==4
     
[b,A]=libsvmread([pathtoroot,'/gisette/gisette_scale']);
A=full([ones(size(A,1),1),A]); %Density above 0.9
[options.btest,options.Atest]=libsvmread([pathtoroot,'/gisette/gisette_scale.t']);
options.Atest=full(options.Atest);

options.Atest=[ones(size(options.Atest,1),1),options.Atest];
Datasetname='gisette';
options.L=svds(A,1)^2/(4*size(A,1));
elseif dataset==5
[b,A]=libsvmread([pathtoroot,'/real-sim/real-sim']);
A=[ones(size(A,1),1),A]; %Introduce intercept
options.Atest=sparse(0,size(A,2));
options.btest=zeros(0,1);
Datasetname='real-sim';
options.L=svds(A,1)^2/(4*size(A,1));
end
clear INFO

%
if 1
options.printout=0;
options.method=1;
options.gamma=10^-10;

if dataset==0 %Makes plots prettier
options.maxit=161;
options.savemod=4;
else
 options.maxit=50000
 options.savemod=100;
end
options.tol=10^-6;
s = RandStream('mt19937ar','Seed',101); RandStream.setGlobalStream(s);
%for k=-:1:5
if dataset==3 || dataset==5
    finalmethod=4; %Exclude Newton for webspam and real-sim dataset
else
    finalmethod=5;
end

for k=-1:1:finalmethod
    if k==5 %Easier to exclude Newton
    options.method=2; %Newton
    elseif k==3 %Gradient
    options.method=3;
    options.maxit=1500
    elseif k==4 %Fast Gradient
        options.method=4;
        options.maxit=4000
    else %Sketched Newton
    options.method=1;
     options.maxit=50000

    if dataset==0
        multiplyer=20;
    else
        multiplyer=250;
    end
    options.sketchsize=(k+2)*multiplyer;
    end
tic
options.method
[x,info]=LogisticSparseSketch(A,b,options);
toc
INFO{k+2,1}=info;
end
%%
legendon=1;
yaxis=1;
maxtime=0;
if dataset==0
yli=0.25;
else
    yli=inf;
end
% Compare sketchsizes w-time
    figure(3)
Legendentries=cell(size(INFO,1),1);
minval=inf;
    Markers={'v' ; '^' ; '>' ; '<'; 'o' ; 'diamond' ; 'square' ; 'pentagram' ; 'hexagram';'+' ;  '*' ; 'x'     }

for k=1:size(INFO,1)
semilogy(INFO{k}.Track(:,4),INFO{k}.Track(:,3),'Linewidth',2,'Marker',Markers{k},'Markersize',8)
            hold on
xlabel('wall-clock time (seconds)','Interpreter','latex','FontSize',23)
%if yaxis==0
set(gca,'YTick',[])
%else
  %  ylabel('$\|g\|_2$ on $\log_{10}$-scale','Interpreter','latex','FontSize', 30)

%end
if INFO{k}.method==1
Legendentries{k}=['RSN, s=',num2str(INFO{k}.sketchsize)];
elseif INFO{k}.method==2
 Legendentries{k}='Newton';
elseif INFO{k}.method==3
     Legendentries{k}='GD';
elseif INFO{k}.method==4
     Legendentries{k}='AGD';

end
maxtime=max(max(INFO{k}.Track(:,4)),maxtime);
minval=max(min(min(INFO{k}.Track(:,3),minval)),options.tol);
end
xlim([0,min(maxtime,yli)])
ylim([minval,inf])
title(['',Datasetname,'-dataset'],'Interpreter','latex','FontSize', 30)
if legendon==1
legend(Legendentries,'FontSize',22)
end

hold off
print(['time',Datasetname,'gamma=10tothepowerofminusone',num2str(legendon),'.eps'], '-depsc')

%
    figure(4)

Legendentries=cell(size(INFO,1),1);
maxiter=0;
minval=inf;
for k=1:size(INFO,1)
    semilogy(INFO{k}.Track(:,1),(INFO{k}.Track(:,3)),'Linewidth',2,'Marker',Markers{k},'Markersize',8)
            hold on
            xlabel('iterations','Interpreter','latex','FontSize', 23)
if yaxis==0
set(gca,'YTick',[])
else
ylabel('$ \|g\|_2$ on $\log_{10}$-scale','Interpreter','latex','FontSize', 30)

end
if INFO{k}.method==1
Legendentries{k}=['RSN, s=',num2str(INFO{k}.sketchsize)];
elseif INFO{k}.method==2
 Legendentries{k}='Newton';
elseif INFO{k}.method==3
     Legendentries{k}='GD';
elseif INFO{k}.method==4
     Legendentries{k}='AGD';
end
maxiter=max(max(INFO{k}.Track(:,1),maxiter));
minval=max(min(min(INFO{k}.Track(:,3),minval)),options.tol);
end
xlim([0,maxiter])
ylim([minval,inf])
if legendon==1
legend(Legendentries,'FontSize',11)
end
title(['',Datasetname,'-dataset'],'Interpreter','latex','FontSize', 30)
hold off

print(['iterations',Datasetname,'gamma=10tothepowerofminusone',num2str(legendon),'.eps'], '-depsc' )

end
