from optimal_comp import *
import matplotlib.pyplot as plt
import numpy as np

# Creat some plots #

delta_end = 10**(-6)
k_range = range(1,101)

def plotter(eps_per,delta_end,k_range):
    opt_comp_vals = [opt_comp(k,eps_per,delta_end) for k in k_range]
    adv_comp_vals = [(advanced_comp_range(k,eps_per,opt_comp_vals[k-1][1]),opt_comp_vals[k-1][1]) for k in k_range]
    adv_comp_eps = np.array([adv_comp_vals[j][0] for j in range(len(k_range))])
    opt_comp_eps = np.array([opt_comp_vals[j][0] for j in range(len(k_range))])
    return opt_comp_eps / adv_comp_eps

#eps_per1 = 0.005
eps_per1 = 0.1
#eps_per2 = 0.01
eps_per2 = 0.25
#eps_per3 = 0.025
eps_per3 = 0.5
#eps_per4 = 0.05
eps_per4 = 1.0
y1 = plotter(eps_per1,delta_end,k_range)
y2 = plotter(eps_per2,delta_end,k_range)
y3 = plotter(eps_per3,delta_end,k_range)
y4 = plotter(eps_per4,delta_end,k_range)




plt.interactive(False)
plt.plot(k_range,y1,'r',label = "epsilon = %1.3f" %eps_per1)
plt.plot(k_range,y2,'g',label = "epsilon = %1.3f" %eps_per2)
plt.plot(k_range,y3,'b',label = "epsilon = %1.3f" %eps_per3)
plt.plot(k_range,y4,'y',label = "epsilon = %1.3f" %eps_per4)

plt.xlabel("k")
plt.ylabel("Ratio of Opt Comp to Range Bounded Comp")
plt.title("Ratio of Privacy Loss for delta< 1e-6")
plt.legend(loc = 'best')
#plt.savefig('PrivacyLossComp.pdf')
plt.show()