package coreset;

import java.util.List;

import base.Line;
import base.Point;
import clust.Objective;
import clust.WeightedPoint;
import clust.ZObjective;

public class KMeans1D extends Coreset1D
{

	protected KMeans1D(List<WeightedPoint> pointSet, Line line, List<Point> optCenters) {
		super(pointSet, line, optCenters);
	}

	@Override
	protected double evaluateError(double start, double end) {
		return WeightedPoint.cumulError(WeightedPoint.fracSubList(this.data.toPoints(), start, end), 
				getObjective());
	}

	@Override
	protected double getThreshold(double eps, int k, double opt)
	{
        return eps * eps * opt / k / k;
	}

	@Override
	protected Objective getObjective() {
		return ZObjective.getObjective(2.0);
	}
}
