package coreset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import base.Line;
import base.Point;
import clust.Clustering;
import clust.Objective;
import clust.WeightedPoint;
import solver.ClusteringSolver;

public abstract class Coreset
{
	ArrayList<WeightedPoint> instance;
	protected Coreset(ArrayList<WeightedPoint> instance)
	{
		this.instance = instance;
	}

	protected abstract ArrayList<WeightedPoint> getCoresetPoint(Segment s);
	protected abstract Objective getObjective();

	private ArrayList<WeightedPoint> getCoresetPoints(ArrayList<Segment> list)
	{
		ArrayList<WeightedPoint> res = new ArrayList<WeightedPoint>();
		for (Segment s : list)
		{
			List<Segment> segCol = s.breakByColor();
			for (Segment seg : segCol)
			{
				res.addAll(getCoresetPoint(seg));
			}
		}
		return res;
	}

	protected abstract Coreset1D construct1D(List<WeightedPoint> l, Line line, List<Point> optCenters);
	protected abstract List<Line> projectToLines(int k, double eps, List<Point> optCenters);
	private List<Point> getOptCenters(int k)
	{
		return ClusteringSolver.localSearch(instance, k, this.getObjective());
	}

	public List<WeightedPoint> getCoreset(double eps, int k)
	{
		ArrayList<WeightedPoint> res = new ArrayList<WeightedPoint>();
		List<Point> optCenters = this.getOptCenters(k);

		List<Line> lines = this.projectToLines(k, eps, optCenters);
		System.out.println("# lines: " + lines.size());
		List<WeightedPoint>[] lineClustering = Clustering.getLineClustering(this.instance, lines);
		
		List<Coreset1D> onedList = new ArrayList<Coreset1D>();
		for (int i = 0; i < lines.size(); i++)
		{
			List<WeightedPoint> clust = lineClustering[i];
			onedList.add(this.construct1D(clust, lines.get(i), optCenters));
			/*HashMap<Integer, List<WeightedPoint>> colMap = WeightedPoint.colorMap(clust);
			for (Integer c : colMap.keySet())
			{
				onedList.add(this.construct1D(colMap.get(c), lines.get(i), c, optCenters));
			}*/
		}

		for (Coreset1D oned : onedList)
		{
			if (oned.isEmpty())
				continue;
			res.addAll(this.getCoresetPoints(oned.getSegments(eps, k)));
		}
		
		return res;
	}
}
