package clust;

import java.util.HashMap;

public class ZObjective implements Objective
{
	private double z;
	private ZObjective(double z) {this.z = z;}
	@Override
	public double value(double v) {
		return Math.pow(Math.abs(v), z);
	}
	private static HashMap<Double, Objective> M = new HashMap<Double, Objective>();
	public static Objective getObjective(double z)
	{
		if (!M.containsKey(z))
		{
			M.put(z, new ZObjective(z));
		}
		return M.get(z);
	}
}
