#!/bin/bash
# $1: Cuda div
# $2: Directory to dump logs

# The directory where to dump the logs
DIR=$2
mkdir -p $DIR

export CUDA_VISIBLE_DEVICES=$1

if [ "$(ls -A $DIR)" ]; then
	read -n1 -p "$DIR is not Empty. Should I clean it? [y,n]:" doit
	case $doit in  
		y|Y) echo ; rm -rv $DIR/* ;;
		n|N) echo ; exit ;;
		*) echo ; exit ;;
	esac
fi


python -u experiment_05_StackedLSTMFC.py \
	--data-dir /datadrive/${USER}/Divide_and_Conquer/data/Google-13/all_data/ \
	--hidden-dim0 64 \
	--num-fc 64 \
	--keep-prob0 0.9 \
	--learning-rate 0.0025 \
	--batch-size 128 \
	--epochs 20 \
	--momentum 0.9 \
	--group-size 8 \
	--checkpoint-dir $2 | tee $2/logs.out
