#!/bin/bash
# Test structure-only model.

# SET HERE.
# Directory db5 dataset was extracted to.
DB5_DIR=
# Directory structure-only model was trained at.
MODEL_DIR=

if [ -z $MODEL_DIR ] || [ -z $DB5_DIR ]
then
    echo "Please specify parameters in test.sh first!"
    exit
fi

LIST=$DB5_DIR/lists/DB5-update.txt
TEST_NAME=DB5-update-unbound-heavy6
SUBMODEL_DIR=$MODEL_DIR/$TEST_NAME
TEST_SIZE=4

# Configure prediction run.
python main.py config interact test $DB5_DIR/ptt/unbound_heavy6/ $TEST_SIZE $SUBMODEL_DIR/test.json -l $SUBMODEL_DIR/test-config.log -dir 20 -b 4 -r 20 -g 1 --keep_file_testing=$LIST
cp $LIST $SUBMODEL_DIR/list.txt

# Run prediction.
python main.py predict $MODEL_DIR/model.json $SUBMODEL_DIR/test.json $MODEL_DIR $SUBMODEL_DIR

# Eval per-complex AUC.
python -m scripts.eval $MODEL_DIR
