
## Installation

### Prerequisites

Before setting up Mayo, you will need to have [Git][git], [Git-LFS][git-lfs], [Python 3.6.5 or above][python3] and [TensorFlow 1.11 or above][tensorflow] installed.

Other dependencies are specified in `requirements.txt`.

### Dataset Preparation

The user will have to generate `tfrecord` files for the ImageNet dataset.
A detailed guide can be found [here](https://github.com/kmonachopoulos/ImageNet-to-TFrecord).

## Running Command

```bash
./my \
    datasets/imagenet.yaml \
    models/override/resnet18.yaml \
    models/override/quantize/recentralize/mle.yaml \
    system.checkpoint.load=resnet18_focused_5bits \
    eval info
```

Sample output:
```Bash
- Using GPUs: 0
- Using GPUs: 0
! Ignoring "CUDA_VISIBLE_DEVICES", as it is overridden by "system.visible_gpus".
* Using config yaml 'datasets/imagenet.yaml'...
* Using config yaml 'models/override/resnet18.yaml'...
* Using config yaml 'models/override/quantize/recentralize/mle.yaml'...
* Overriding config with 'system.checkpoint.load=resnet18_focused_5bits'...
* Executing command 'eval'...
- Starting a validate session...
- Loading checkpoint from 'checkpoints/resnet18/imagenet/resnet18_focused_5bits'...
- Starting evaluation...
⣿ validate: 100.00% | top1: 68.37% | top5: 88.45% | tp:  436/s
- Evaluation complete.
-     top1: 68.36%, top5: 88.45% [50000 images]
```

We only provide a resnet18 model to show the implementation,
all the reported models in the paper will be open sourced later
on a public accessible cloud storage later and code will be hosted on Github.
