#ifndef SIM_H_INCLUDED
#define SIM_H_INCLUDED

#include <random>
#include <vector>
#include "crowd.h"
#include "infer.h"
#include "policy.h"

// holds the results of a single run (abstract class)
class sim {
public:
    crowd* cwd;
    infer* inf;
    policy* poly;

    virtual ~sim() = default;
    virtual void run(std::mt19937& ran_gen) = 0;
};

// run the simulation with a fixed amount of labels
class sim_budget: public sim {
public:
    unsigned int n_labels;

    sim_budget(crowd* cwd, infer* inf, policy* poly, unsigned int n_labels);
    ~sim_budget();
    void run(std::mt19937& ran_gen);
};

// run the simulation with a target error rate
class sim_error: public sim {
public:
    double target_odds;

    sim_error(crowd* cwd, infer* inf, policy* poly, double target_err);
    ~sim_error();
    void run(std::mt19937& ran_gen);
};

// sim parser
sim* sim_parse(int *argc, char **argv[]);

// home-made unit tests
void sim_budget_test();
void sim_error_test();
void sim_parse_test();

#endif // SIM_H_INCLUDED
