#ifndef POLICY_H_INCLUDED
#define POLICY_H_INCLUDED

#include <vector>
#include "crowd.h"
#include "infer.h"

// allocates a worker to a task (abstract class)
class policy {
public:
    virtual ~policy(){};
    virtual void choose_task(crowd* c, infer* inf, unsigned int t) = 0;
};

// uniform allocation policy
class policy_uniform: public policy {
private:
    unsigned int t_next;
    std::vector<bool> task_ignore;
public:
    std::vector<unsigned int> task_count;

    policy_uniform();
    void choose_task(crowd* c, infer* inf, unsigned int t);
};

// uncertainty sampling policy
class policy_uncertainty: public policy {
private:
    unsigned int t_next;
    std::vector<bool> task_ignore;
public:
    std::vector<double> task_abs_odds;

    policy_uncertainty();
    void choose_task(crowd* c, infer* inf, unsigned int t);
};

// policy parser
policy* policy_parse(int *argc, char **argv[]);

// home-made unit tests
void policy_uniform_test();
void policy_uncertainty_test();
void policy_parse_test();

#endif // POLICY_H_INCLUDED
