function [gw] = DoubleConvotron_g_ReLU( w, v, x, y )

r = length(w);
k = length(v);
n = length(y);

%yhat = zeros(1,n);
%xsum = zeros(r,1);

%gw = zeros(r,1);
Sigma_transpose = zeros(k,n);

for j=1:k
    Sigma_transpose(j,:) = CNN_ReLU( w.' * x(((j-1)*r + 1):(j*r),:) );
end

yhat = (v.') * Sigma_transpose;


xsum = zeros(r,n);
for j=1:k
    xsum = xsum + v(j) * x(((j-1)*r + 1):(j*r),:);
end

gw = - 2 * xsum * ((y - yhat).') / n + 0.25 * (norm(w)^2 - norm(v)^2) * w;

