# Copyright (c) 2017-present, Facebook, Inc.
#
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.

# This defines
# ATEN_FOUND - if ATEN was found
# ATEN_INCLUDE_DIRS - include directories
# ATEN_LIBRARIES - libraries to link to

FIND_PATH(ATEN_INCLUDE_DIR ATen/ATen.h PATHS "${PROJECT_SOURCE_DIR}/autogradpp/pytorch/torch/lib/include/" NO_DEFAULT_PATH)
FIND_LIBRARY(ATEN_LIBRARY ATen PATHS "${PROJECT_SOURCE_DIR}/autogradpp/pytorch/torch/lib" NO_DEFAULT_PATH)

IF(NOT ATEN_LIBRARY)
  FIND_PATH(ATEN_INCLUDE_DIR ATen/ATen.h PATHS ${ATEN_DIR} ENV ATEN_DIR PATH_SUFFIXES include)
  FIND_LIBRARY(ATEN_LIBRARY ATen PATHS ${ATEN_DIR} ENV ATEN_DIR PATH_SUFFIXES lib)
ENDIF()

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(ATEN DEFAULT_MSG ATEN_LIBRARY ATEN_INCLUDE_DIR)

MARK_AS_ADVANCED(ATEN_INCLUDE_DIR ATEN_LIBRARY)

SET(ATEN_INCLUDE_DIRS ${ATEN_INCLUDE_DIR} "${ATEN_INCLUDE_DIR}/TH"
  "${ATEN_INCLUDE_DIR}/THS" "${ATEN_INCLUDE_DIR}/THNN")
SET(ATEN_LIBRARIES ${ATEN_LIBRARY} ${ATEN_TH_LIBRARY} ${ATEN_THS_LIBRARY} ${ATEN_THNN_LIBRARY})

ADD_LIBRARY(ATen SHARED IMPORTED)
SET_TARGET_PROPERTIES(ATen PROPERTIES
  IMPORTED_LOCATION ${ATEN_LIBRARY}
  INTERFACE_INCLUDE_DIRECTORIES ${ATEN_INCLUDE_DIR})

