#!/usr/bin/env bash
SOURCE_FOLDERS='common cpid experimental src'
SOURCE_FILES=`find $SOURCE_FOLDERS  -name \*.cpp -type f -or -name \*.h -type f`
JUNIT_XML='/tmp/test_clangformat.xml'
TOTAL_FILES_WITH_ERRORS='0'
echo "<testsuite name='check-clang-format'>" > $JUNIT_XML
GIT_CURRENT_BRANCH=`git branch | grep \* | cut -d ' ' -f2`
GIT_MASTER_AT=`git merge-base "$GIT_CURRENT_BRANCH" origin/master`
echo "Most recent common ancestor between master and $GIT_CURRENT_BRANCH: $GIT_MASTER_AT"
for SOURCE_FILE in $SOURCE_FILES
do
  export FORMATTING_ISSUES_COUNT=`clang-format -output-replacements-xml $SOURCE_FILE | grep offset | wc -l`
  export FORMATTING_ISSUES_COUNT_MASTER=`git show $GIT_MASTER_AT:$SOURCE_FILE | clang-format -output-replacements-xml -assume-filename=$SOURCE_FILE | grep offset | wc -l`
  ERRORS_ADDED=$((FORMATTING_ISSUES_COUNT - FORMATTING_ISSUES_COUNT_MASTER))
  if [ "$FORMATTING_ISSUES_COUNT" -gt "0" ]; then
    echo "[FAIL]   $SOURCE_FILE has $FORMATTING_ISSUES_COUNT formatting issues (vs $FORMATTING_ISSUES_COUNT_MASTER in master). Please use clang-format tool to resolve found issues."
    echo "<testcase classname=\"clangformat\" name=\"$SOURCE_FILE\"><failure type=\"failed\">Doesn't respect clang format. Fix with \`find $SOURCE_FOLDERS -iname \"*.h\" -o -iname \"*.cpp\" | xargs clang-format -i\`</failure></testcase>" >> $JUNIT_XML
    TOTAL_FILES_WITH_ERRORS=$((TOTAL_FILES_WITH_ERRORS+1))
  else
    echo "[OK]     $SOURCE_FILE"
    echo "<testcase classname=\"clangformat\" name=\"$SOURCE_FILE\"/>" >> $JUNIT_XML
  fi
done
echo "</testsuite>" >> $JUNIT_XML
mkdir -p /tmp/test-results/check-clang-format
mv $JUNIT_XML /tmp/test-results/check-clang-format
echo "$TOTAL_FILES_WITH_ERRORS files with errors"
if [ "$TOTAL_FILES_WITH_ERRORS" -gt "0" ]; then
  exit 1
fi
