# Code organization

This folder contains the code necessary to replicate the training of the models. We also provide the best quad model pretrained on the wraith scenario, for testing purposes.

- cpid/ contains the training algorithm. The most relevant file is a2c.cpp which contains our continous a2c implementation
- src/ contains the logic to play starcraft game, with a rudimentary bot.
- experiments/targeting contains the important files. model.cpp is the model that we use, targeting.cpp contains the main-loop, featurize.cpp describe which features are extracted and how, solver.cpp contains the LP and Quad solver, and targetingmodule.cpp handles the communication between the models and the game, and also implements the heuristics.


# Building 

## Prerequisites

### TL;DR

Here's a short overview of everything that's required:
- Libraries and development files for zeromq (version 4.2), gflags, glog, curl and sdl2
- All PyTorch requirements to compile PyTorch
- [NCCL2](https://developer.nvidia.com/nccl) in order to use TorchCraftAI's model training library

### Install Required Packages
```bash
sudo apt-get update
sudo apt-get install git libsdl2-dev libzmq3-dev binutils-dev libdw-dev libgflags-dev libnuma-dev cmake curl libcurl-dev libgoogle-glog-dev
```

`apt-get` may complain about not finding an installation candidate for `libcurl-dev`.
In this case, replace `libcurl-dev` with one of the suggested alternatives.

For training on GPUs, NVIDIA's CUDA Toolkit is required. We strongly recommend [CUDA 9.2](https://developer.nvidia.com/cuda-92-download-archive) as older and newer versions suffer from incompabilities with newer compilers and the PyTorch stack, respectively.
For optimal performance, be sure to install [cuDNN](https://developer.nvidia.com/cudnn) as well.

### Build PyTorch Backend Libraries
Since we live on the bleeding edge of PyTorch, you'll unfortunately have to compile your own pytorch libraries.

Here's a summary for compiling with an Anaconda installation:

```bash

# Download Anaconda from https://www.anaconda.com/download/#linux
bash Anaconda-latest-Linux-x86_64.sh

export CMAKE_PREFIX_PATH="$(dirname $(which conda))/../" # [anaconda root directory]

# Install basic dependencies
conda install numpy pyyaml mkl mkl-include setuptools cmake cffi typing
conda install -c mingfeima mkldnn

# Add LAPACK support for the GPU
conda install -c pytorch magma-cuda92 # or [magma-cuda80 | magma-cuda91] depending on your cuda version

pushd 3rdparty/pytorch/tools/
REL_WITH_DEB_INFO=1 python build_libtorch.py
popd
```

We recommend the [github instructions](https://github.com/ebetica/pytorch/tree/agppv0.4-1#from-source) if you run into issues with these steps.
Alternatively, instead of using Anaconda, you may install everything yourself, or choose not to install every optimization, such as mkl-dnn, if you prefer for a simpler installation process.

### Build and install Zstandard

We also require a manual Zstandard installation. This can be done as follows:
```bash
curl -sSL https://github.com/facebook/zstd/archive/v1.3.3.tar.gz | tar xvzf -
pushd zstd-1.3.3/build/cmake
cmake . -DCMAKE_C_FLAGS=-fPIC -DCMAKE_CXX_FLAGS=-fPIC -DZSTD_BUILD_STATIC=ON -DCMAKE_BUILD_TYPE=Release -DZSTD_LEGACY_SUPPORT=0
make -j$(nproc)
sudo make install
popd
```

### Build and Install OpenBW
```bash
pushd 3rdparty/openbw
mkdir -p build
cd build
cmake .. -DCMAKE_BUILD_TYPE=release -DOPENBW_ENABLE_UI=1
make -j$(nproc)
sudo make install
popd
```

### Install StarCraft
OpenBW requires the MPQ data files from an installation of StarCraft: Brood War.
You can either copy them from your existing StarCraft installation (maybe on a Windows machine) or perform the installation locally with Wine:
1. [Install Wine](https://wiki.winehq.org/Ubuntu)
2. From inside Wine, install StarCraft 1.16.1. Note that MPQs from newer versions (like 1.18 or 1.2 (Remastered)) are not supported yet
3. Find the MPQ files: `find ~/.wine/ -name "*.mpq"`
4. Set the MPQ file location for OpenBW: `echo 'export OPENBW_MPQ_PATH=[Path where you found the MPQs]' >> ~/.bashrc`


## Building the project
At the top-level directory:

```bash
mkdir -p build
cd build
cmake .. -DCMAKE_BUILD_TYPE=relwithdebinfo [-DWITH_CPIDLIB=OFF] # Turn CPIDLIB off if you don't have the NCCL2 library installed
make -j$(nproc)
```


# Profit!

To evaluate the model that is provided, you can simply try:
```
./build/experimental/targeting/targeting --minloglevel 0 -v -1 --scenario wraith --model_type quad_dm --use_pairwise_feats --batch_size 1 --num_workers 1 --policy_momentum 0 --sigma 0.00000000007185 --returns_length 3 --correlated_steps 1 --optim adam --seed 37630 --eval --num_episodes 1 --cpu_only  --normalize_dist --dump_replay --enable_gui --eval_policy w15v16_best.bin --scenario_size 15 --difficulty 0
```

This will run one episode of wraith 15 vs 17, showing a gui, and saving a replay. You can increase the number of enemy units by increasing the difficulty flag.


To replicate training of the above model, run:
```
./build/experimental/targeting/targeting --minloglevel 0 -v -1 --scenario wraith --seed 42 --model_type quad_dm --dump_replay --use_pairwise_feats --difficulty 0 --normalize_dist --batch_size 32 --num_workers 64 --scenario_size 15 --policy_momentum 0 --lr 2.826e-05 --policy_ratio 251.4 --sigma 1.899 --returns_length 6 --correlated_steps 7 --optim adam
```
