/*
 * Copyright (c) 2017 ARM Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifndef __ARM_COMPUTE_GCACTIVATIONLAYERKERNEL_H__
#define __ARM_COMPUTE_GCACTIVATIONLAYERKERNEL_H__

#include "arm_compute/core/GLES_COMPUTE/IGCKernel.h"

namespace arm_compute
{
class IGCTensor;

/** Interface for the activation layer kernel. */
class GCActivationLayerKernel : public IGCKernel
{
public:
    /** Default constructor */
    GCActivationLayerKernel();
    /** Prevent instances of this class from being copied (As this class contains pointers) */
    GCActivationLayerKernel(const GCActivationLayerKernel &) = delete;
    /** Prevent instances of this class from being copied (As this class contains pointers) */
    GCActivationLayerKernel &operator=(const GCActivationLayerKernel &) = delete;
    /** Allow instances of this class to be moved */
    GCActivationLayerKernel(GCActivationLayerKernel &&) = default;
    /** Allow instances of this class to be moved */
    GCActivationLayerKernel &operator=(GCActivationLayerKernel &&) = default;
    /** Default destructor */
    ~GCActivationLayerKernel() = default;
    /** Set the input and output tensor.
     *
     * @note If the output tensor is a nullptr, the activation function will be performed in-place
     *
     * @param[in, out] input    Source tensor. In case of @p output tensor = nullptr, this tensor will store the result
     *                          of the activation function. Data types supported: F16/F32.
     * @param[out]     output   Destination tensor. Data type should match the input data type.
     * @param[in]      act_info Activation layer information.
     */
    void configure(IGCTensor *input, IGCTensor *output, ActivationLayerInfo act_info);

    // Inherited methods overridden:
    void run(const Window &window) override;

private:
    IGCTensor *_input;
    IGCTensor *_output;
};
}
#endif /*__ARM_COMPUTE_GCACTIVATIONLAYERKERNEL_H__ */
