%% set up

clear;
addpath('../aux'); %test;
addpath('../figures');
addpath('../results'); %test;

design='HLLT'; %NP, SSG, HLLT
[f,sim,x_vis,f_vis]=get_design(design);

% sample size
N=1000;

% simulate data, split into stage 1 and 2 samples
rng('default');
rho=0.5;
[x,y,z]=sim(f,N,rho);

%% sieve

df=get_basis(x,y,z,x_vis);

% evaluate on full sample using tuned hyperparameters
y_vis=sieveIV_pred(df,[0,0],3); %lambda=xi=0

% mse
disp('mse:');
disp(mse(y_vis,f_vis));