function df = get_basis(x,y,z,x_vis)
% precalculate basis matrices

% hyperparameters
df.SJ=1; df.SK=1; df.rJ=4; df.rK=4;

[x1, x2, y1, y2, z1, z2]=split(x,y,z,.5);

df.y1=y1;
df.y2=y2;
df.y=y;

df.X1=bsplinemat(x1,df.SJ,df.rJ);
df.X2=bsplinemat(x2,df.SJ,df.rJ);
df.X_vis=bsplinemat(x_vis,df.SJ,df.rJ);

df.Z1=bsplinemat(z1,df.SK,df.rK);
df.Z2=bsplinemat(z2,df.SK,df.rK);

end

