rm(list=ls())
require(ggplot2)
library(dplyr)

setwd("~/Documents/research/kiv/kiv_fix/supplement/code/results")

#############
# read in csv
#############

alg_options<-'KIV'
alg_names<-'KernelIV'

design_options<-'NP'
design_names<-c('Sigmoid')

dfs<-vector('list',length(alg_options)*length(design_options))
#expression(paste0('Demand ',rho,'=0.9'))

alg='KIV'
design='NP'
test<-read.csv(paste0(alg,'_',design,'_1000_2.csv'),header=FALSE)

a=1
d=6
i=1

for (a in 1:length(alg_options)) {
  
  alg<-alg_options[a]
  alg_name<-alg_names[a]
  
  for (d in 1:length(design_options)) {
    
    design<-design_options[d]
    design_name<-design_names[d]
    
    mse2<-read.csv(paste0(alg,'_',design,'_1000_2.csv'),header=FALSE)
    mse4<-read.csv(paste0(alg,'_',design,'_1000_4.csv'),header=FALSE)
    mse6<-read.csv(paste0(alg,'_',design,'_1000_6.csv'),header=FALSE)
    mse8<-read.csv(paste0(alg,'_',design,'_1000_8.csv'),header=FALSE)
    mse10<-read.csv(paste0(alg,'_',design,'_1000_10.csv'),header=FALSE)
    
    mse<-c(mse2[[1]],mse4[[1]],mse6[[1]],mse8[[1]],mse10[[1]])
    n<-c(rep(.2,40),rep(.4,40),rep(.6,40),rep(.8,40),rep(1,40))
    
    df<-data.frame(alg_name,design_name,mse,n)
    dfs[[i]]<-df
    i<-i+1
  }
}

df_all<-df
df_all$mse<-log10(df_all$mse)
df_all$n<-as.factor(df_all$n)

df_all$alg_name <- factor(df_all$alg_name, levels = "KernelIV")

names(df_all)<-c("Algorithm","design_name","mse","n")

###########
# make plot
###########

myplot2 <- ggplot(filter(df_all, design_name== "Sigmoid", Algorithm!= "SieveIV"))
myplot2+geom_boxplot(aes(x = n, y =mse, color = Algorithm), fill= "mediumorchid1", position = "identity", alpha = .3)+facet_grid(facets = .~design_name)+theme_bw()+ 
  xlab("               Gaussian kernel hyperparameter") + ylab("Out-of-Sample MSE (log)")+scale_color_manual(values = "mediumorchid1")
ggsave(filename = "../figures/robust.eps", device=cairo_ps, fallback_resolution = 600, width=3, height=2)
