library(np)
library(tictoc)

df<-read.csv("df_in.csv",sep=",",header=FALSE)
names(df)<-c('p','t','s','y','z')

#match order of sorting to x_vis from get_design.m
df <- df[order(df$t),]
df <- df[order(df$p),]
df <- df[order(df$s),]

p<-df[[1]]
t<-df[[2]]
s<-df[[3]]
y<-df[[4]]
z<-df[[5]]

ts<-data.frame(t,s)

df_vis<-read.csv("df_vis.csv",sep=",",header=FALSE)
p_vis<-df_vis[[1]]
t_vis<-df_vis[[2]]
s_vis<-df_vis[[3]]

ts_vis<-data.frame(t_vis,s_vis)

#tic('kernel smoothing IV')
model.iv <- npregiv(y=y,
                    z=p,
                    w=z,
                    x=ts, 
                    zeval=p_vis, 
                    xeval=ts_vis, 
                    method="Tikhonov",
                    p=0) #p=0 req. for multidim exog case to run. same spec. as HLLT
#toc()

y_vis <- model.iv$phi.eval

#plot(x_vis,y_vis)

write.csv(y_vis,file = "df_out.csv")