clear;
addpath('../aux'); %test;
addpath('../figures');
addpath('../results'); %test;

design='HLLT'; %NP, SSG, HLLT
[f,sim,x_vis,f_vis]=get_design(design);

% sample size
N=1000;

% simulate data, split into stage 1 and 2 samples
rng('default');
rho=0.5;
[x,y,z]=sim(f,N,rho);

%% kernel ridge reg - no IV, 2-fold CV

% precalculate all kernel matrices
df=get_K(x,y,z,x_vis);

% initialize hyperparameters for tuning
lambda0=log(0.05);

% tuning by CV
kernel_ridge_obj=@(lambda) kernel_ridge_cv(df,exp(lambda)); %exp to ensure pos
lambda_star=fminunc(kernel_ridge_obj,lambda0);

% evaluate on full sample using tuned hyperparameters
y_vis=kernel_ridge_pred(df,exp(lambda_star),3); %exp to ensure pos

% mse
disp('mse:');
disp(mse(y_vis,f_vis));