#include "krelu_transformer.h"

/*****
	Check if the given constraint is redundant, used when working with only constraints
******/

int is_redundant(GRBenv *env ,double_matrix_t *oc, size_t ind){
	
	
  	GRBmodel *model = NULL;
	
	

	/********* create the model ******/
	size_t i;
	size_t nbcons = oc->nbrows;
        size_t nbvars = oc->nbcolumns -2;
	double * lb = (double *)malloc(nbvars*sizeof(double));
	double * ub = (double *)malloc(nbvars*sizeof(double));
	for(i=0; i < nbvars; i++){
		lb[i] = -INFINITY;
		ub[i] = INFINITY;
	}
	
	char   *sense = (char*)malloc(nbcons*sizeof(char));
	double * rhs = (double *)malloc(nbcons*sizeof(double));
	int i1 = 0;
	for(i=0; i < nbcons; i++){
		if(i==ind){
			continue;
		}
		double *pi = oc->p[i];
		sense[i1] = pi[0] ?  GRB_LESS_EQUAL : GRB_EQUAL;
		rhs[i1] = pi[1];
		i1++;
	}

	GRBnewmodel(env, &model, "get_bounds", nbvars, NULL, lb, ub, NULL, NULL);
	GRBaddconstrs(model, nbcons-1, 0, NULL, NULL, NULL, sense, rhs, NULL);

	//int error = 
        GRBsetintparam(GRBgetenv(model), "OutputFlag", 0);
	//printf("error: %d\n",error);
	i1=0;	
	for(i=0; i < nbcons; i++){
		if(i==ind){
			continue;
		}
		double *pi = oc->p[i];
		size_t j;
		//int i1 = (int)i;		
		for(j=0; j < nbvars; j++){
			int j1 = (int)j;
			double val = -pi[j+2];
			GRBchgcoeffs(model, 1, &i1, &j1, &val);
		}
		i1++;
	}
	
	free(sense);
	free(rhs);
	free(lb);
	free(ub);
	
	double *pind = oc->p[ind];
        for(size_t j=0; j < nbvars; j++){ 
		double val = -pind[j+2];
		GRBsetdblattrelement(model, "Obj", j, val);
	}
        
	 GRBsetintattr(model, "ModelSense",  GRB_MAXIMIZE);
	 GRBoptimize(model);
	 int status = -1;
         double obj = -INFINITY;
	 GRBgetintattr(model, "Status", &status);
	// printf("status: %d %lu %d\n", status==GRB_OPTIMAL,ind,status);
	//fflush(stdout);
	 if (status == GRB_OPTIMAL){
		GRBgetdblattr(model, "ObjVal", &obj);
		//printf("obj: %g bnd: %g\n",obj,pind[1]);
		if(pind[1]>=obj){
			return 1;
		}	
	 }
	GRBfreemodel(model);
	//GRBwrite(model,"/tmp/model.lp");
	return 0;
}



/************************************
	Remove syntactically equivalent inequalities
***********************************/

void quasi_removal_constraint(double_matrix_t * oc){
	size_t nbcolumns;
	long long int nbcons = (long long int)oc->nbrows;
	nbcolumns = oc->nbcolumns;
	long long int nb = nbcons;
	long long int nbeq = (long long int)oc->nbeq;
        size_t *rmap = (size_t *)calloc(nbcons,sizeof(size_t));
	int i,j;
	
	for(i = 0; i < (long long int)nbcons; i++){
		double *pi = oc->p[i];
		for(j = i+1; j < (long long int)nbcons; j++){
			double* pj = oc->p[j];
			if((pi[0]==pj[0]) && (!double_vector_compare_coeff(pi,pj,nbcolumns))){
				if(!pi[0]){
					nbeq--;
				}
				//nbcons--;
				if(pi[1] > pj[1]){
                    			rmap[i] = 1;
					
				}
				else{
                   			 rmap[j] = 1;
					
				}	
				
			}
			else if(!pi[0]){
				double *npj = double_vector_neg(pj,nbcolumns);
				if(!double_vector_compare(pi,npj,nbcolumns)){
					if(pi[1]==npj[1]){
						rmap[j] = 1;
						nbeq--;
					}
				}
				free(npj);
			}
		}
	}
    j = nbcons - 1;
    for(i=0; i < nb; i++){
	//printf("i: %d rmap[i]: %d\n",i,rmap[i]);
        if(rmap[i]){
            nbcons--;
            while((j>i) && rmap[j]){
                j--;
            }
            if(j>i){
                double_matrix_exch_rows(oc,i,j);
	    }
	    j--;
        }
    }
    free(rmap);
  
   oc->nbrows = nbcons;
   oc->nbeq = nbeq;	

}
/********
	Minimize polyhedra by removing redundant constraints
*******/
void remove_redundancy(GRBenv   *env, double_matrix_t * oc){
	quasi_removal_constraint(oc);
	
	size_t nbcolumns;
	long long int nbcons;
	size_t  j;
	long long int i = 0;
	nbcons = (long long int)oc->nbrows;
	if(nbcons<=1){
		return;
	}
	nbcolumns = oc->nbcolumns;
	double **p = oc->p;
	while(i < nbcons){
		
		double *pi = p[i];
		int type;
		double bnds;
		if(!pi[0]){
			i++;
			continue;
		}
		else{
			int res = is_redundant(env, oc,i);
			//printf("res: %d %lld %lld\n",res,i,nbcons);
			if(res==1){
				
				nbcons --;
				oc->nbrows = nbcons;
				double_matrix_exch_rows(oc,i,nbcons);
			}
			else{
				i++;
			}
		}
	}
    return;
}




/***************************
	Select a variable for gauss projection
****************************/
int select_variable_gauss_elimination(double_matrix_t *oc,  double *cons, size_t nbeq, size_t *tdim, size_t size, char *rmap){
	int res = -1;
	size_t nbcons = oc->nbrows;
	size_t nbcolumns = oc->nbcolumns;
	size_t i,j;
	size_t * p = (size_t *)calloc(size,sizeof(size_t));
	size_t * m = (size_t *)calloc(size,sizeof(size_t));
	for(i=nbeq; i < nbcons; i++){
		double *pi = oc->p[i];
		for(j=0; j < size; j++){
			size_t dim = 2 + tdim[j];
			if(!cons[dim] || rmap[j]){
				continue;
			}
			if(pi[dim]<0){
				m[j]++;
			}
			else if(pi[dim]>0){
				p[j]++;
			}
		}	
	}
	long long int maxadd = -nbcons*nbcons;
	//printf("maxadd: %d");
	long long int ind = -1;
	for(j=0; j < size; j++){
		size_t dim = 2 + tdim[j];
		if(!rmap[j] && cons[dim]){
			long long int nbadd = p[j]*m[j] - p[j] -m[j];
			if(nbadd >= maxadd){
				maxadd = nbadd;
				res = dim; 
				ind = j;
			}
		}
	}

	if(res!=-1){
		rmap[ind] = 1;
		//printf("ind: %d\n",ind);
	}
	free(p);
	free(m);
		
	return res;
}



/*****************************
	Select a variable for Fourier-Motzkin
******************************/
void select_variable_fourier(size_t *tdim, size_t size, double_matrix_t * oc,  long long int *nbadd, long long int *maxadd){
	
	size_t i, j, k;
	size_t * p = (size_t *)calloc(size,sizeof(size_t));
	size_t * m = (size_t *)calloc(size,sizeof(size_t));
	size_t nbcolumns = oc->nbcolumns;
	size_t nbcons = oc->nbrows;
	for(i = 0; i < nbcons; i++){
		double *pi = oc->p[i];
		for(j = 0; j < size; j++){
			double pj = pi[2 + tdim[j]];
			if(pj > 0){
				p[j]++;
			}
			else if(pj < 0){
				m[j]++;
			}
		}
		
	}
	
	size_t ind = 0;
	*nbadd = nbcons*nbcons;
	*maxadd = nbcons*nbcons;
	for(i = 0; i < size; i++){
		int tmp = p[i]*m[i] - p[i] - m[i];
		if(tmp < *nbadd){
			*maxadd = p[i]*m[i];
			*nbadd = tmp;
			ind = i;
		}
	} 
	
	/**********
		Always put chosen variable at last position
	***********/
	size_t tmp = tdim[size-1];
	tdim[size-1] = tdim[ind];
	tdim[ind] = tmp;
	free(p);
	free(m);
	
}


int gauss_elimination(double_matrix_t *oc, size_t *tdim, size_t *tsize){
	//printf("before gauss\n");
	//double_matrix_print(oc);
	size_t nbrows = oc->nbrows;
	size_t nbeq = oc->nbeq;
	size_t nbcolumns = oc->nbcolumns; 
	size_t i, j, l,  c2 = 0;
	int s;
	size_t size = *tsize;
	char *rmap = (char *)calloc(size,sizeof(char));
	double **p = oc->p;
	for(i=0; i < nbeq; i++){
		int exch = 0;
		double *pi = p[i];
		//s = -1;
		double * npi;
		
		s = select_variable_gauss_elimination(oc,pi,nbeq,tdim,size,rmap); 
		if(s==-1){	
			
			double_matrix_exch_rows(oc,i,c2);
			c2++;
		}
		else{
			npi = double_vector_neg(pi,nbcolumns);
			if(pi[s] < 0){
				double *tmp = npi;
				npi = pi;
				pi = tmp; 
				exch  = 1;	
			}
			l=0;
			while(l < nbrows){
				if(l==i){
					l++;
					continue;
				}
				double * pl = p[l];
				if(pl[s]==0){
					l++;
					continue;
				}
				else{
					//printf("before gauss\n");
					//double_matrix_print(oc);
					if(pl[s] > 0){
						double_vector_combine(pl, npi, pl, s, nbcolumns, 1);
					}
					else{
						double_vector_combine(pl, pi, pl, s, nbcolumns,1);
					}
					//printf("after gauss\n");
					//double_matrix_print(oc);
					if(double_vector_is_null_expr(pl, nbcolumns)){
						//printf("coming here1\n");
						/*** Null Inequality ***/
						if(pl[0]){
							if(pl[1] < 0){
								if(exch){
									free(pi);
								}
								else{
									free(npi);
								}
								return 0;
							}
							else{
								nbrows--;
								double_matrix_exch_rows(oc,l,nbrows);
							}
						}
						/**** Null Equality ***/
						else{
							//printf("coming here2\n");
							if(pl[1]!= 0){
								if(exch){
									free(pi);
								}
								else{
									free(npi);
								}
								return 0;
							}else{
								nbrows--;
								double_matrix_exch_rows(oc,l,nbrows);
							}
						}
					}
					else{
						l++;
					}
					
				}
			
			}
			if(exch){
				free(pi);
			}
			else{
				free(npi);
			}
		}
	}
	
	for(i = c2; i < nbeq; i++){
		nbrows--;
		double_matrix_exch_rows(oc,i,nbrows);
	}
	oc->nbrows = nbrows;
	
	size_t k = 0;
	for(i = 0; i < size; i++){
		if(!rmap[i]){
			tdim[k] = tdim[i]; 
			k++;
		}
	}
	*tsize = k;
	oc->nbeq = c2;
	free(rmap);
	//printf("after gauss %d\n",oc->nbeq);
	//double_matrix_print(oc);
	return 1;
}

/*************************************
	Fourier-Motzkin Elimination
*************************************/
int fourier_motzkin_double(size_t dim, double_matrix_t * oc){
	size_t nbcons = oc->nbrows;
	size_t nbcolumns = oc->nbcolumns;	
	size_t *ocm = (size_t*)calloc(nbcons,sizeof(size_t));	
	size_t *ocp = (size_t *)calloc(nbcons, sizeof(size_t));
	size_t *ocn = (size_t *)calloc(nbcons, sizeof(size_t));
	size_t nbcons1 = 0, nbcons2 = 0, nbcons3 = 0;
	/****
		Result matrix will add at most nbadd inequalities
	*****/
	
	size_t i, j;
	for(i= 0; i < nbcons; i++){
		double * pi = oc->p[i];
		if(pi[dim] > 0){
			ocp[nbcons2] = i;
			nbcons2++;
		}
		else if(pi[dim] < 0){
			ocm[nbcons1] = i;
			nbcons1++;
		}
		else{
			ocn[nbcons3] = i;
			nbcons3++;
		}
	}
	size_t s = 0;
	for(i = 0; i < nbcons1; i++){
	   size_t mind = ocm[i];
	   double * pi = oc->p[mind];
	   double fi = -pi[dim];
	   for(j = 0; j < nbcons2; j++){
		size_t pind = ocp[j];
		double * pj = oc->p[pind];
		double fj = pj[dim];
		double * tmp1, *tmp2;
		//printf("start\n");
		
		if(fabs(fi)!=fabs(fj)){
		   tmp1 = double_vector_scalar_product(pi,fj, nbcolumns);
		   tmp2 = double_vector_scalar_product(pj,fi, nbcolumns);
		}else{
		   tmp1 = (double*)malloc(nbcolumns*sizeof(double));
		   tmp2 = (double*)malloc(nbcolumns*sizeof(double));
		   double_vector_copy(tmp1,pi,nbcolumns);
		   double_vector_copy(tmp2,pj,nbcolumns);
		}
		double_vector_sum(tmp1, tmp2, nbcolumns);
		
		if(!double_vector_is_null_expr(tmp1,nbcolumns)){
			double * dst = oc->p[s+nbcons];
			double_vector_copy(dst,tmp1,nbcolumns);
			s++;
		}
		
		free(tmp1);
		free(tmp2);
	   }
	}
	for(i=0; i <nbcons3; i++){
		size_t nind = ocn[i];
		double_matrix_exch_rows(oc,i,nind);
	}
	for(i=0; i < s; i++ ){
		double_matrix_exch_rows(oc,nbcons3+i,nbcons+i);
	}
	oc->nbrows = s + nbcons3;
	free(ocm);
	free(ocp);
	free(ocn);
	return 1;	
}


/*********************************
	Project an array of variables from the factor
**********************************/
void double_poly_project_variables(GRBenv   *env, double_matrix_t* op,  size_t* tdim, size_t size){
	size_t i,j;
	long long int nbcons = (long long int)op->nbrows;
	size_t nbcolumns = op->nbcolumns;
	double_matrix_rearrange(op);
	gauss_elimination(op, tdim,&size);
	
	nbcons = op->nbrows;
	long long int limit = nbcons;	
	long long int  nbadd;
	long long maxadd;
	while(size > 0){

		select_variable_fourier(tdim,size,op, &nbadd, &maxadd);
		size_t dim = tdim[size-1] + 2;
		nbcons = op->nbrows; 
		//printf("nbcons: %d nbadd: %d dim: %d size: %d maxrows: %d maxadd: %d\n",nbcons,nbadd,dim,size,ocp->_maxrows,maxadd);
		matrix_resize_rows(op,op->nbrows + maxadd);
		op->nbrows = nbcons;
		fourier_motzkin_double(dim,op);
		
		quasi_removal_constraint(op);
		nbcons = op->nbrows; 
		
		size--;
		if(size>0){
			select_variable_fourier(tdim,size,op, &nbadd, &maxadd);
			if(nbcons+nbadd > limit){
				remove_redundancy(env,op);
				limit = op->nbrows;
			}
			
		}
	}
	
	remove_redundancy(env, op);
	return;
}




double_matrix_t * double_poly_join_cons(GRBenv   *env, double_matrix_t *oa, double_matrix_t *ob){
	//printf("oa before %llu\n",oa->nbeq);
        //double_matrix_print(oa);	
	remove_redundancy(env, oa);
	//printf("oa after %llu\n",oa->nbeq);
	//double_matrix_print(oa);

	//printf("ob before %llu\n",ob->nbeq);
       // double_matrix_print(ob);
	remove_redundancy(env, ob);	
	//printf("ob after %llu\n",ob->nbeq);
	//double_matrix_print(ob);
	/*******************************
		Prepare the data structure for result
	********************************/
	size_t i,j;
	size_t nbconsa = oa->nbrows;
	size_t nbconsb = ob->nbrows;
	size_t num_vars = oa->nbcolumns - 2;

	size_t nbcons = nbconsa+nbconsb+3;
	size_t init_vars = 2*num_vars + 4;
	double_matrix_t * tmp = double_matrix_alloc(nbcons,init_vars);
	tmp->nbeq = oa->nbeq + ob->nbeq + 1;
	/*************************
		Encode sigma1 + sigma2 = 1
	**************************/
	double **ptmp = tmp->p;

	double *ptmpi = ptmp[0];
	ptmpi[0] = 0;
	ptmpi[1] = -1;
	ptmpi[2] = 1;
	ptmpi[3] = 1;
	

	/**************************
		Encode sigma1 >= 0 and sigma2 >= 0
	***************************/
	ptmpi = ptmp[1];
	ptmpi[0] = 1;	
	ptmpi[1] = 0;
	ptmpi[2] = 1;

	ptmpi = ptmp[2];
	ptmpi[0] = 1;	
	ptmpi[1] = 0;
	ptmpi[3] = 1;
		
		
	/*****************************
		Compute tdim
	*****************************/
	size_t *tdim = (size_t *)malloc((num_vars+2)*sizeof(size_t));
		
	unsigned short int l = num_vars + 2;
	tdim[0] = 0;
	tdim[1] = 1;
	for(i = 2; i < num_vars+2; i++){
			
		tdim[i] = l;
		l++;
	}	
	
	

	/***************************
		Encode A1y <= sigma1c1
	****************************/
	size_t s1 = 3;
	
	for(i = 0; i < nbconsa; i++){
		double * pai = oa->p[i];
		double * ptmpi = tmp->p[s1];
		ptmpi[0] = pai[0];
		ptmpi[1] = 0;
		ptmpi[2] = pai[1];
		unsigned short int l = 0;
			
			
		size_t c1 = num_vars + 4;
		for(j = 0; j < num_vars; j++){
			ptmpi[c1+j] = pai[j+2];
		}
		s1++;
	}
		
		
		
	/***************************
		Encode A2(x-y) <= sigma2c2
	****************************/
	
	for(i = 0; i < nbconsb; i++){
		double *pbi = ob->p[i];
		double *ptmpi = tmp->p[s1];
		ptmpi[0] = pbi[0];
		ptmpi[1] = 0;
		ptmpi[3] = pbi[1];
		unsigned short int l = 0;
		unsigned short int c1 = num_vars + 4;
			
		unsigned short int c3 = 4;
		for(j = 0; j < num_vars; j++){	
			ptmpi[c1+j] = -pbi[j+2];
			ptmpi[c3+j] = pbi[j+2];
		}
		s1++;
	}
		

	
	double_poly_project_variables(env, tmp,tdim, num_vars+2);
	//printf("tmp\n");
	//double_matrix_print(tmp);
	nbcons = tmp->nbrows;
	double_matrix_t * op = double_matrix_alloc(nbcons,oa->nbcolumns);
	
	
	for(i=0; i < nbcons; i++){
		double *pci = op->p[i];
		double *ptmpi = tmp->p[i];
		pci[0] = ptmpi[0];
		pci[1] = ptmpi[1];
		for(j=0; j < num_vars; j++){
			pci[j+2] = ptmpi[j+4];
		} 
	}
	op->nbeq = tmp->nbeq;
		//printf("op\n");
		//double_matrix_print(op);
	free(tdim);
	double_matrix_free(tmp);
	
	return op;
}


void populate_matrix_2_var(double_matrix_t *oc, double *x_coeff, double * y_coeff, double *lb, double *ub, double *xy, int type){
	double **ocp = oc->p;
	double *pi = ocp[0];
	pi[0] = 0;
	pi[1] = 0;
	pi[4] = 1;
	if(type<=2){
		pi[2] = -1;		
	}
	
	pi = ocp[1];
	pi[1] = 0;
	pi[5] = 1;
	if(type==1 || type==4){
		pi[3] = -1;
	}

	// x <= u
	pi = ocp[2];
	pi[0] = 1;
	if(type<=2){
		pi[1] = ub[0];
	}
	else{
		pi[1] = 0;
	}
	pi[2] = -1;
	
	// x >= l
	pi = ocp[3];
	pi[0] = 1;
	if(type<=2){
		pi[1] = 0;
	}
	else{
		pi[1] = -lb[0];
	}
	pi[2] = 1;

	// y <= u
	pi = ocp[4];
	pi[0] = 1;
	if(type==1 || type==4){
		pi[1] = ub[1];
	}
	else{
		pi[1] = 0;
	}
	pi[3] = -1;

	// y >= l
	pi = ocp[5];
	pi[0] = 1;
	if(type==1 || type==4){
		pi[1] = 0;
	}
	else{
		pi[1] = -lb[1];
	}
	pi[3] = 1;

	//x+y <= a1
	pi = ocp[6];
	pi[0] = 1;
	pi[1] = xy[0];
	pi[2] = -x_coeff[0];
	pi[3] = -y_coeff[0];
	
	// x-y <= a2
	pi = ocp[7];
        pi[0] = 1;
	pi[1] = xy[1];
	pi[2] = -x_coeff[1];
	pi[3] = y_coeff[1];	

	
	// -x-y <= a3
	pi = ocp[8];
	pi[0] = 1;
	pi[1] = xy[2];
	pi[2] = x_coeff[2];
	pi[3] = y_coeff[2];

	// y -x <= a4
	pi = ocp[9];
	pi[0] = 1;
	pi[1] = xy[3];
	pi[2] = x_coeff[3];
	pi[3] = -y_coeff[3];
}


void populate_matrix_3_var(double_matrix_t *oc, double *lb, double *ub, double *xyz, int type){
	double **ocp = oc->p;
	double *pi = ocp[0];
	pi[0] = 0;
	pi[1] = 0;
	pi[5] = 1;
	if(type<=4){
		pi[2] = -1;		
	}
	
	pi = ocp[1];
	pi[0] = 0;
	pi[6] = 1;
	if((type%4)<=2){
		pi[3] = -1;
	}


	pi = ocp[2];
	pi[0] = 1;
	pi[7] = 1;
	if((type%2)==1){
		pi[4] = -1;
	}

	// x <= u
	pi = ocp[3];
	pi[0] = 1;
	if(type<=4){
		pi[1] = ub[0];
	}
	else{
		pi[1] = 0;
	}
	pi[2] = -1;
	
	// x >= l
	pi = ocp[4];
	pi[0] = 1;
	if(type<=4){
		pi[1] = 0;
	}
	else{
		pi[1] = -lb[0];
	}
	pi[2] = 1;

	// y <= u
	pi = ocp[5];
	pi[0] = 1;
	if((type%4)<=2){
		pi[1] = ub[1];
	}
	else{
		pi[1] = 0;
	}
	pi[3] = -1;

	// y >= l
	pi = ocp[6];
	pi[0] = 1;
	if((type%4)<=2){
		pi[1] = 0;
	}
	else{
		pi[1] = -lb[1];
	}
	pi[3] = 1;



	// z <= u
	pi = ocp[7];
	pi[0] = 1;
	if((type%2)==1){
		pi[1] = ub[2];
	}
	else{
		pi[1] = 0;
	}
	pi[4] = -1;

	// z >= l
	pi = ocp[8];
	pi[0] = 1;
	if((type%2)==1){
		pi[1] = 0;
	}
	else{
		pi[1] = -lb[2];
	}
	pi[4] = 1;
	

	//x+y+z <= a1
	pi = ocp[9];
	pi[0] = 1;
	pi[1] = xyz[0];
	pi[2] = -1;
	pi[3] = -1;
	pi[4] = -1;
	
	// x+y-z <= a2
	pi = ocp[10];
        pi[0] = 1;
	pi[1] = xyz[1];
	pi[2] = -1;
	pi[3] = -1;	
	pi[4] = 1;
	
	// x-y+z <= a3
	pi = ocp[11];
	pi[0] = 1;
	pi[1] = xyz[2];
	pi[2] = -1;
	pi[3] = 1;
	pi[4] = -1;

	// x-y-z <= a4
	pi = ocp[12];
	pi[0] = 1;
	pi[1] = xyz[3];
	pi[2] = -1;
	pi[3] = 1;
	pi[4] = 1;


	//-x+y+z <= a5
	pi = ocp[13];
	pi[0] = 1;
	pi[1] = xyz[4];
	pi[2] = 1;
	pi[3] = -1;
	pi[4] = -1;
	
	// -x+y-z <= a6
	pi = ocp[14];
        pi[0] = 1;
	pi[1] = 1;//xyz[5];
	pi[2] = 1;
	pi[3] = -1;
	pi[4] = 1;
	
	// -x-y+z <= a7
	pi = ocp[15];
	pi[0] = 1;
	pi[1] = 1;//xyz[6];
	pi[2] = 1;
	pi[3] = 1;
	pi[4] = -1;

	// -x-y-z <= a8
	pi = ocp[16];
	pi[0] = 1;
	pi[1] = 1;//xyz[7];
	pi[2] = 1;
	pi[3] = 1;
	pi[4] = 1;
	
	// w >=z
	//pi = ocp[17];
	//pi[0] = 1;
	//pi[7] = 1;
	//pi[4] = -1;

	// w <= lambda.z + mu
	//pi = ocp[18];
	//double lambda = ub[2]/(ub[2]-lb[2]);
	//double mu = -lb[2]*lambda;
	//pi[0] = 1;
	//pi[1] = mu;
	//pi[7] = -1;
	//pi[4] = lambda;


	// v >=y
	//pi = ocp[19];
	//pi[0] = 1;
	//pi[6] = 1;
	//pi[3] = -1;

	// v <= lambda.y + mu
	//pi = ocp[20];
	//lambda = ub[1]/(ub[1]-lb[1]);
	//mu = -lb[1]*lambda;
	//pi[0] = 1;
	//pi[1] = mu;
	//pi[6] = -1;
	//pi[3] = lambda;
	
}



//x_coeff,y_coeff contain positive entries
double_matrix_t* relu_with_2_var(double *x_coeff, double * y_coeff, double *lb, double * ub, double *xy){
	/*if(lb[0]>=0 || lb[1]>=0){
		printf("WTF?\n");
	}
	if(ub[0]<=0 || ub[1]<=0){
		printf("WTFU\n");
	}*/
	//printf("coeff: %g %g %g %g\n",x_coeff[0],x_coeff[1],y_coeff[0],y_coeff[1]);
	double_matrix_t * px_py = double_matrix_alloc(10,6);
	px_py->nbeq = 2;
	populate_matrix_2_var(px_py,x_coeff, y_coeff, lb,ub,xy,1);

	double_matrix_t * px_ny = double_matrix_alloc(10,6);
	px_ny->nbeq = 2;
	populate_matrix_2_var(px_ny, x_coeff, y_coeff, lb,ub,xy,2);

	double_matrix_t * nx_ny = double_matrix_alloc(10,6);
	nx_ny->nbeq = 2;
	populate_matrix_2_var(nx_ny, x_coeff, y_coeff, lb,ub,xy,3);

	double_matrix_t * nx_py = double_matrix_alloc(10,6);
	nx_py->nbeq = 2;
	populate_matrix_2_var(nx_py, x_coeff, y_coeff, lb,ub,xy,4);
	//printf("first\n");
	//double_matrix_print(px_py);
	//printf("second\n");
	//double_matrix_print(px_ny);
	//printf("third\n");
	//double_matrix_print(nx_ny);
	//printf("fourth\n");
	//double_matrix_print(nx_py);
	GRBenv   *env   = NULL;
	GRBemptyenv(&env);
	GRBstartenv(env);
	double_matrix_t *tmp1 = double_poly_join_cons(env, nx_ny, nx_py);
	//printf("first join %lu\n",tmp1->nbrows);
	//double_matrix_print(tmp1);
	double_matrix_t *tmp2 = double_poly_join_cons(env, px_py, px_ny);
	//printf("second join %lu\n",tmp2->nbrows);
	//double_matrix_print(tmp2);
	double_matrix_t *res = double_poly_join_cons(env, tmp1, tmp2);

	//printf("third join %lu\n",res->nbrows);
	//double_matrix_print(res);
	
	double_matrix_free(px_py);
	double_matrix_free(px_ny);
	double_matrix_free(nx_ny);
	double_matrix_free(nx_py);
	double_matrix_free(tmp1);
	double_matrix_free(tmp2);
	GRBfreeenv(env);
	return res;
} 

double_matrix_t * neg_x_varsyz(double *lb, double *ub){
	double_matrix_t * res = double_matrix_alloc(13,8);
	double **ocp = res->p;
	double *pi = ocp[0];
	pi[0] = 0;
	pi[1] = 0;
	pi[5] = 1;
	

	// x <= u
	pi = ocp[1];
	pi[0] = 1;
	pi[2] = -1;
	
	// x >= l
	pi = ocp[2];
	pi[0] = 1;
	pi[1] = -lb[0];
	pi[2] = 1;

	// y <= u
	pi = ocp[3];
	pi[0] = 1;
	pi[1] = ub[1];
	pi[3] = -1;

	// y >= l
	pi = ocp[4];
	pi[0] = 1;
	pi[1] = -lb[1];
	pi[3] = 1;

	// z <= u
	pi = ocp[5];
	pi[0] = 1;
	pi[1] = ub[2];
	pi[4] = -1;

	// z >= l
	pi = ocp[6];
	pi[0] = 1;
	pi[1] = -lb[2];
	pi[4] = 1;

	//w>=0
	pi = ocp[7];
	pi[0] = 1;	
	pi[6] = 1; 

	// w>=y
	pi =ocp[8];
	pi[0] = 1;
	pi[3] = -1;
	pi[6] = 1;	

	//w<=lambda.y + mu
	double lambda = ub[1]/(ub[1]-lb[1]);
	double mu = -lb[1]*lambda;
	pi = ocp[9];
	pi[0] = 1;
	pi[1] = mu;
	pi[6] = -1;
	pi[3] = lambda;


	//v>=0
	pi = ocp[10];
	pi[0] = 1;	
	pi[7] = 1; 

	// v>=z
	pi =ocp[11];
	pi[0] = 1;
	pi[4] = -1;
	pi[7] = 1;	

	//v<=lambda.z + mu
	lambda = ub[2]/(ub[2]-lb[2]);
	mu = -lb[2]*lambda;
	pi = ocp[12];
	pi[0] = 1;
	pi[1] = mu;
	pi[7] = -1;
	pi[4] = lambda;
	return res;
}


double_matrix_t* relu_with_3_var(double *lb, double * ub, double *xyz){
	//printf("start\n");
	//fflush(stdout);
	double_matrix_t * px_py_pz = double_matrix_alloc(17,8);
	px_py_pz->nbeq = 3;
	populate_matrix_3_var(px_py_pz,lb,ub,xyz,1);
	
	double_matrix_t * px_py_nz = double_matrix_alloc(17,8);
	px_py_nz->nbeq = 3;
	populate_matrix_3_var(px_py_nz,lb,ub,xyz,2);

	double_matrix_t * px_ny_pz = double_matrix_alloc(17,8);
	px_ny_pz->nbeq = 3;
	populate_matrix_3_var(px_ny_pz,lb,ub,xyz,3);

	double_matrix_t * px_ny_nz = double_matrix_alloc(17,8);
	px_ny_nz->nbeq = 3;
	populate_matrix_3_var(px_ny_nz,lb,ub,xyz,4);
	//printf("coming here\n");
	//fflush(stdout);

	double_matrix_t * nx_py_pz = double_matrix_alloc(17,8);
	nx_py_pz->nbeq = 3;
	populate_matrix_3_var(nx_py_pz,lb,ub,xyz,5);

	double_matrix_t * nx_py_nz = double_matrix_alloc(17,8);
	nx_py_nz->nbeq = 3;
	populate_matrix_3_var(nx_py_nz, lb,ub,xyz,6);

	double_matrix_t * nx_ny_pz = double_matrix_alloc(17,8);
	nx_ny_pz->nbeq = 3;
	populate_matrix_3_var(nx_ny_pz, lb,ub,xyz,7);

	double_matrix_t * nx_ny_nz = double_matrix_alloc(17,8);
	nx_ny_nz->nbeq = 3;
	populate_matrix_3_var(nx_ny_nz, lb,ub,xyz,8);
	
	

	GRBenv   *env   = NULL;
	GRBemptyenv(&env);
	GRBstartenv(env);
	double_matrix_t *tmp1 = double_poly_join_cons(env, px_py_pz, px_py_nz);
	//printf("end1 %lu\n",tmp1->nbrows);
	//fflush(stdout);
	double_matrix_t *tmp2 = double_poly_join_cons(env, px_ny_pz, px_ny_nz);
	//printf("end2 %lu\n",tmp2->nbrows);
	//fflush(stdout);
	double_matrix_t *tmp3 = double_poly_join_cons(env, nx_py_pz, nx_py_nz);
	//printf("end3 %lu\n",tmp3->nbrows);
	//fflush(stdout);
	double_matrix_t *tmp4 = double_poly_join_cons(env, nx_ny_pz, nx_ny_nz);
	//printf("end4 %lu\n",tmp4->nbrows);
	//fflush(stdout);
	
	//if(tmp1->nbrows>10){
	//	tmp1->nbrows = 10;
	//}

	//if(tmp2->nbrows>10){
	//	tmp2->nbrows = 10;
	//}

	//if(tmp3->nbrows>10){
	//	tmp3->nbrows = 10;
	//}

	//if(tmp4->nbrows>10){
		//tmp4->nbrows = 10;
	//}
	double_matrix_t *tmp5 = double_poly_join_cons(env, tmp1, tmp2);
	//printf("end5 %lu\n",tmp5->nbrows);
	//fflush(stdout);
	double_matrix_t *tmp6 = double_poly_join_cons(env, tmp3, tmp4);
	//double_matrix_t *tmp6 = neg_x_varsyz(lb,ub);
	//printf("end6 %lu\n",tmp6->nbrows);
	//fflush(stdout);
	//if(tmp5->nbrows>10){
	//	tmp5->nbrows = 10;
	//}
	//if(tmp6->nbrows>10){
	//	tmp6->nbrows = 10;
	//}
	double_matrix_t *res = double_poly_join_cons(env, tmp5, tmp6);
	
	printf("third join %lu\n",res->nbrows);
	//double_matrix_print(res);
	
	double_matrix_free(px_py_pz);
	double_matrix_free(px_py_nz);
	double_matrix_free(px_ny_pz);
	double_matrix_free(px_ny_nz);

	double_matrix_free(nx_py_pz);
	double_matrix_free(nx_py_nz);
	double_matrix_free(nx_ny_pz);
	double_matrix_free(nx_ny_nz);

	double_matrix_free(tmp1);
	double_matrix_free(tmp2);
	double_matrix_free(tmp3);
	double_matrix_free(tmp4);
	double_matrix_free(tmp5);
	double_matrix_free(tmp6);

	GRBfreeenv(env);
	
	return res;
} 
