#ifndef __DOUBLE_MATRIX_H__
#define __DOUBLE_MATRIX_H__


#ifdef __cplusplus
extern "C" {
#endif

#include "double_vector.h"


typedef struct double_matrix_t {
  /* public part */
  double ** p;     /* array of pointers to rows */
  size_t nbrows;      /* number of effective rows */
  size_t nbcolumns;   /* size of rows */

  /* private part */
  size_t  _maxrows;   /* number of rows allocated */
  size_t nbeq;
} double_matrix_t;

/* Basic Operations */
double_matrix_t* double_matrix_alloc(size_t nbrows, size_t nbcols);
void matrix_resize_rows(double_matrix_t* mat, size_t nbrows);
void double_matrix_free(double_matrix_t* mat);
void double_matrix_exch_rows(double_matrix_t* om, size_t l1, size_t l2);
void double_matrix_rearrange(double_matrix_t *oc);

void double_matrix_print(double_matrix_t* mat);

size_t get_num_rows(double_matrix_t *mat);
double get_matrix_element(double_matrix_t *mat, size_t i, size_t j);

#ifdef __cplusplus
}
#endif

#endif
