import calc_frechet
import numpy as np
import pandas as pd
import sys
import json

if len(sys.argv) < 4:
	dat1 = "PS1"
	dat2 = "PS2"
	epsilon = 0.4
	
else:
	dat1 = sys.argv[1]
	dat2 = sys.argv[2]
	epsilon = float(sys.argv[3])

def import_from_txt(path):
    data = pd.read_csv(path, sep="\t", header=None)
    return data

#Import the data


name1 = "../data/{}.txt".format(dat1)
name2 = "../data/{}.txt".format(dat2)

data1 = import_from_txt(name1)
data2 = import_from_txt(name2)

data_np_array1 = data1.values
data_np_array2 = data2.values
data_np_array1 = np.array(data_np_array1, dtype="d")
data_np_array2 = np.array(data_np_array2, dtype="d")

d1 = calc_frechet.Curve(data_np_array1)
d2 = calc_frechet.Curve(data_np_array2)

d = calc_frechet.Curves()

d.add(d1)
d.add(d2)

drp = calc_frechet.jl_transform(d, epsilon)

distance_p = calc_frechet.calculate_distance_parallel(d[0], d[1])
distance = calc_frechet.calculate_distance(d[0], d[1])
distance_p_rp = calc_frechet.calculate_distance_parallel(drp[0], drp[1])
distance_rp = calc_frechet.calculate_distance(drp[0], drp[1])

dump = {
	'data': {
		'names': [dat1, dat2],
		'lengths': [len(data_np_array1), len(data_np_array2)],
		'dimensions': [len(data_np_array1[0]), len(data_np_array2[0])],
		'epsilon': epsilon,
	},
	'sequential': {
		'without_rp': {
			'rt_b': distance.time_bounds,
			'rt_s': distance.time_searches,
			'n_s': distance.number_searches,
			'value': distance.value,
		},
		'with_rp': {
			'rt_b': distance_rp.time_bounds,
			'rt_s': distance_rp.time_searches,
			'n_s': distance_rp.number_searches,
			'value': distance_rp.value,
		},
	},
	'parallel': {
		'without_rp': {
			'rt_b': distance_p.time_bounds,
			'rt_s': distance_p.time_searches,
			'n_s': distance_p.number_searches,
			'value': distance_p.value,
		},
		'with_rp': {
			'rt_b': distance_p_rp.time_bounds,
			'rt_s': distance_p_rp.time_searches,
			'n_s': distance_p_rp.number_searches,
			'value': distance_p_rp.value,
		},
	},
}

print(json.dumps(dump))
