function [C, leftClusters] = lfm_wrapper(inputFile,k,lambda)
	pythonPath = SETUP_matlab('SETUP_PYTHON_PATH');
	pythonFile = SETUP_matlab('SETUP_LFM_PATH');
	outFile = tempname();
	clusterOutputFile = tempname();


	call = [pythonPath ' ' pythonFile ' -i ' inputFile ' -o ' outFile ' -k ' int2str(k) ' --lambda ' num2str(lambda,3) ' --clusterOutputFile ' clusterOutputFile ];
	[status result] = unix(call);

	if status ~= 0
		error(['lfm returned an error code ' int2str(status) ' with text ' result]);
	end

	C = readFileIfExists( outFile );
	leftClusters = readFileIfExists(clusterOutputFile);

	C = threshold(C);
	leftClusters = threshold(leftClusters);
	
	delete(outFile)
	delete(clusterOutputFile)
end

function [C] = threshold(C)
	C( C >= 0.5 ) = 1;
	C( C < 0.5 ) = 0;
end

function [ C ] = readFileIfExists(outFile)
	nonemptyOutfile = 0;
	if exist(outFile, 'file')
		fid = fopen(outFile);    
		line_ = fgets(fid);    
		if ~(isequal(line_, -1)) 
			nonemptyOutfile = 1;
		end
	end

	if nonemptyOutfile == 1
		C = csvread(outFile);
	else
		C = [];
	end
end

