function [leftClusters, rightClusters] = kmeans_rows_cols(A, k)
% First applies k-means to the rows of A and then
% applies 2-means on each cluster returned by the first step.

% apply kmeans to clusters rows
idx = kmeans(A, k);

[m, n] = size(A);
rightClusters = zeros(1,n);

j = 1;
% now cluster the columns in each cluster
for i = 1:k
	% consider cluster i

	cluster = A( idx == i, : );

	% round to entries in the cluster
	cluster( cluster >= 0.5 ) = 1;
	cluster( cluster < 0.5 ) = 0;

	% apply 2-means on the rounded A
	idxCluster = kmeans(cluster', 2);

	rightClusters(j,:) = zeros(1,n);
	rightClusters(j, idxCluster == 1) = 1;
	rightClusters(j+1,:) = zeros(1,n);
	rightClusters(j+1, idxCluster == 2) = 1;

	j = j+2;
end

leftClusters = zeros(k,m);
for i = 1:k
	leftClusters( i, idx == i ) = 1;
end

end
