import random
from scipy.spatial.distance import pdist, squareform
from sklearn.cluster import KMeans

''' The algorithms in this file cluster the COLUMNS of the given matrix H. '''

def kmeans(H,k):
	est = KMeans(n_clusters=int(k))
	est.fit(H.T)
	labels = est.labels_

	clusterDict = {}
	for i in range(len(labels)):
		cluster = labels[i]
		if cluster not in clusterDict:
			clusterDict[cluster] = [i]
		else:
			clusterDict[cluster].append(i)

	clusters = clusterDict.values()

	return clusters

