from matrix_completion import MatrixCompletion
from utilities import *

import sys, getopt

def from_file(csv_file, outfile, clusterOutputFile, K, p_x_1, p_y_1, p_1_given_1, p_0_given_0):
	O = read_csv(csv_file).astype(int)

	mask = np.ones(O.shape, dtype=bool)
	comp = MatrixCompletion(O, K, mask = mask, min_sum = True, verbose = True, p_x_1 = p_x_1, p_y_1 = p_y_1, p_1_given_1 = p_1_given_1, p_0_given_0 = p_0_given_0)
	comp.run()

	print('number of nonzeros: {}'.format(np.count_nonzero(comp.Y)))
	print('writing to file {}'.format(outfile))
	np.savetxt(outfile, comp.Y.T, delimiter=',')
	np.savetxt(clusterOutputFile, comp.X.T, delimiter=',')

def main(argv):
	K = 1
	p_x_1 = 0.5
	p_y_1 = 0.5
	p_0_given_0 = 0.9
	p_1_given_1 = 0.9

	try:
		opts, args = getopt.getopt(argv,"k:i:o:",["p_x_1=","p_y_1=","p_0_given_0=","p_1_given_1=","clusterOutputFile="])
	except getopt.GetoptError:
		printHelp()
		sys.exit(2)
	for opt, arg in opts:
		if opt  == "-i":
			inputfile = arg
		elif opt == "-o":
			outputfile = arg
		elif opt == "--clusterOutputFile":
			clusterOutputFile = arg
		elif opt == "-k":
			K = int(arg)
		elif opt == "--p_x_1":
			p_x_1 = float(arg)
		elif opt == "--p_y_1":
			p_y_1 = float(arg)
		elif opt == "--p_0_given_0":
			p_0_given_0 = float(arg)
		elif opt == "--p_1_given_1":
			p_1_given_1 = float(arg)
		else:
			print("unknown option {0}".format(opt))
			sys.exit()

	from_file(inputfile, outputfile, clusterOutputFile, K, p_x_1, p_y_1, p_1_given_1, p_0_given_0)

if __name__ == "__main__":
	main(sys.argv[1:])

