library(tidyverse)
library(ggpubr)

# TIMES

timesin <- read_csv("results/all_in.combined_csv") %>%
  mutate(time = time + 0.01)

b1_lower <- 0.005
b1_upper <- 0.01
b2_upper <- 0.02

timesin_b1 <- timesin %>%
  filter(distance > b1_lower, distance <= b1_upper)
  
timesin_b2 <- timesin %>%
  filter(distance > b1_upper, distance <= b2_upper)

times1_m <- timesin_b1 %>%
  filter(dataset=="mnist", algorithm == "kgraph" | algorithm == "hnsw" | algorithm == "SW-graph") %>%
  mutate(parameters = paste(c2, c1, sep=", ")) %>%
  group_by_at(vars(algorithm, dataset)) %>%
  mutate(ratio = time / buildtime)

p1_m <- ggplot(times1_m, aes(factor(algorithm), ratio)) +
  ggtitle("MNIST, 0.01 bucket") +
  scale_x_discrete(name = "algorithm") +
  scale_y_log10(name = "(test. time) / (build. time)") +
  scale_fill_brewer(palette = "Set1") +
  theme(legend.position="none") +
  geom_boxplot(aes(fill = parameters), outlier.alpha = 0.1)

times1_f <- timesin_b1 %>%
  filter(dataset=="fashion", algorithm == "kgraph" | algorithm == "hnsw" | algorithm == "SW-graph") %>%
  mutate(parameters = paste(c2, c1, sep=", ")) %>%
  group_by_at(vars(algorithm, dataset)) %>%
  mutate(ratio = time / buildtime)

p1_f <- ggplot(times1_f, aes(factor(algorithm), ratio)) +
  ggtitle("F.-MNIST, 0.01 bucket") +
  scale_x_discrete(name = "algorithm") +
  scale_y_log10() +
  scale_fill_brewer(palette = "Set1") +
  theme(legend.position="none") +
  geom_boxplot(aes(fill = parameters), outlier.alpha = 0.1) +
  ylab(NULL)

times1_s <- timesin_b1 %>%
  filter(dataset=="sift", algorithm == "kgraph" | algorithm == "hnsw" | algorithm == "SW-graph") %>%
  mutate(parameters = paste(c2, c1, sep=", ")) %>%
  group_by_at(vars(algorithm, dataset)) %>%
  mutate(ratio = time / buildtime)

p1_s <- ggplot(times1_s, aes(factor(algorithm), ratio)) +
  ggtitle("SIFT, 0.01 bucket") +
  scale_x_discrete(name = "algorithm") +
  scale_y_log10() +
  scale_fill_brewer(palette = "Set1") +
  geom_boxplot(aes(fill = parameters), outlier.alpha = 0.1) +
  ylab(NULL)

## second row

times2_m <- timesin_b2 %>%
  filter(dataset=="mnist", algorithm == "kgraph" | algorithm == "hnsw" | algorithm == "SW-graph") %>%
  mutate(parameters = paste(c2, c1, sep=", ")) %>%
  group_by_at(vars(algorithm, dataset)) %>%
  mutate(ratio = time / buildtime)

p2_m <- ggplot(times2_m, aes(factor(algorithm), ratio)) +
  ggtitle("MNIST, 0.02 bucket") +
  scale_x_discrete(name = "algorithm") +
  scale_y_log10(name = "(test. time) / (build. time)") +
  scale_fill_brewer(palette = "Set1") +
  geom_boxplot(aes(fill = parameters), outlier.alpha = 0.1)

times2_f <- timesin_b2 %>%
  filter(dataset=="fashion", algorithm == "kgraph" | algorithm == "hnsw" | algorithm == "SW-graph") %>%
  mutate(parameters = paste(c2, c1, sep=", ")) %>%
  group_by_at(vars(algorithm, dataset)) %>%
  mutate(ratio = time / buildtime)

p2_f <- ggplot(times2_f, aes(factor(algorithm), ratio)) +
  ggtitle("F.-MNIST, 0.02 bucket") +
  scale_x_discrete(name = "algorithm") +
  scale_y_log10() +
  scale_fill_brewer(palette = "Set1") +
  geom_boxplot(aes(fill = parameters), outlier.alpha = 0.1) +
  ylab(NULL)

times2_s <- timesin_b2 %>%
  filter(dataset=="sift", algorithm == "kgraph" | algorithm == "hnsw" | algorithm == "SW-graph") %>%
  mutate(parameters = paste(c2, c1, sep=", ")) %>%
  group_by_at(vars(algorithm, dataset)) %>%
  mutate(ratio = time / buildtime)

p2_s <- ggplot(times2_s, aes(factor(algorithm), ratio)) +
  ggtitle("SIFT, 0.02 bucket") +
  scale_x_discrete(name = "algorithm") +
  scale_y_log10() +
  scale_fill_brewer(palette = "Set1") +
  geom_boxplot(aes(fill = parameters), outlier.alpha = 0.1) +
  ylab(NULL)

ggarrange(p1_m, p1_f, p1_s, p2_m, p2_f, p2_s, ncol = 3, nrow = 2, common.legend = TRUE)
