local M = {}

function M.exec(opt, cacheFile)
   local mnist=require 'mnist'
   local trainData=mnist.traindataset()
   local testData=mnist.testdataset()
   local function convert(dat)
      local tmp=torch.Tensor(dat.size,28,28);
      local l=torch.Tensor(dat.size);
      for i=1,dat.size do
         l[i]=dat[i].y+1
         tmp[i]:copy(dat[i].x):div(256)
      end
      return {
         data=tmp,
         labels=l,
      }
   end

   print(" | saving mnist dataset to " .. cacheFile)
   torch.save(cacheFile, {
      train = convert(trainData),
      val = convert(testData),
   })
end

return M
