# Learned link structures of TrajGRU

The `in.gif`, `gt.gif`, `pred.gif` are the input, the ground-truth and the prediction generated by the TrajGRU-L13 model.

The `links` folder contains gif files for a single selected link in each each layer of the
TrajGRU-L13 model.

Each arrow starts at the position of the link and points to the location read by
the link. ebrnn1, ebrnn2, ebrnn3 mean the first, second and third layers of in the encoding network, respectively. fbrnn1, fbrnn2, fbrnn3 mean the first, second and third layers in the forecasting network. Here, since we have reversed the order of the forecasting network, the fbrnn3 has the smallest feature map size and fbrnn1 has the largest feature map size.

We could see that the flow fields in the first layer of the encoder are generally capturing some local correlations, while the second layer becomes more global and accurate, like in ebrnn1_0_link5.gif, ebrnn2_0_link5.gif and ebrnn3_0_link5.gif.

For the forecaster, the higher layers are guiding the lower layers, so we could see that higher layers are more coarse while the lower layers have fine details, like in fbrnn3_0_link9.gif, fbrnn2_0_link9.gif and fbrnn1_0_link2.gif.