function Indices = FPS( Dm , N)
%FPS - Farthest Point Sampling
%
%   Indices = FPS(Dm,N)
%           
%       Indices - indices in Dm that are farthest apart
%       Dm - Distance matrix to be sampled
%       N - Number of elements to be in Sample

Indices = ones(1,N);

for i=2:N
    d = Dm(Indices(1:(i-1)),:);
    if(i~=2)
        d = min(d);
    end
    [~,ind] = max(d);
    
    Indices(i) = ind;
end

end

