clear;
close all;

% Constants from experiments
H = 100;
Q = 1000;
N = 15;
U = 1;
D = 1;
S = 1;
Seed = 0:50;

[ multi, alternative, circuit, forward, backward ] = aggregate_multi(H, Q, N, U, D, S, Seed);
multi = sort(multi);
alternative = sort(alternative);
circuit = sort(circuit);
forward = sort(forward);
backward = sort(backward);

x = 100 * (Seed - min(Seed)) / (max(Seed) - min(Seed));

f = figure('Position', [100, 100, 250, 200]);
hold on;
plot(x, multi, 'LineWidth', 2);
plot(x, alternative + 0.25 * 25 / 15, 'LineWidth', 2);
plot(x, circuit, 'LineWidth', 2);
plot(x, forward, 'LineWidth', 2);
plot(x, backward, 'LineWidth', 2);
title(['Cost for Setting A']);
xlabel('Percentile');
ylabel('Cost');
xlim([min(x) max(x)]);
ylim([25 50]);
save2pdf(['comparison.pdf']);
%legend('Multiple Threshold (Def 4.4)', 'Alternative (Def D.1)', 'Circuit (Def D.6)', 'Forward (Sec D.1)', 'Backward (Sec D.1)', 'Location', 'EastOutside');

