#include "shared.h"

#include <algorithm>
#include <vector>
#include <random>
#include <cfloat>
#include <eigen3/Eigen/Core>
#include <eigen3/Eigen/LU>
#include <eigen3/Eigen/Eigenvalues>


using namespace std;
using namespace Eigen;



/***************************************************************
* Returns weighted norm of vector
***************************************************************/
float norm(VectorXf v, MatrixXf G) {
  return sqrt(v.transpose() * G * v);
}


/***************************************************************
* Returns square root of positive definite matrix
***************************************************************/
MatrixXf root(MatrixXf &M) {
  int D = M.rows();
  MatrixXf R(D, D);
  EigenSolver<MatrixXf> es;
  es.compute(M, true);
  MatrixXf V = es.eigenvectors().real();
  VectorXf L = es.eigenvalues().real();
  MatrixXf root_L = MatrixXf::Zero(D, D);
  for (int d=0;d!=D;++d) {
    root_L(d,d) = sqrt(L(d));  
  }
  return V * root_L * V.inverse();
}






