#include <iostream>
#include <fstream>
#include <thread>
#include <mutex>
#include <functional>

#include "alloc_alg.h"
#include <eigen3/Eigen/Core>

using namespace std;
using namespace Eigen;

void write_data(vector<Data> data, string fn) {
  ofstream out(fn);
  for (auto &d : data) {
    for (auto x : d) {
      out << x << " ";
    }
    out << "\n";
  }
  out.close();
}

class Counter {
  public:
  int n;
  int job_n;
  mutex n_mutex;
  Counter(int jn) {
    n = 0;
    job_n = jn;
  }
  int inc() {
    int r;
    n_mutex.lock();
    if (n >= job_n) {
      r = 0;
    }else {
      n++;
      r = n;
    }
    n_mutex.unlock();
    return r;
  }
};
void exp2_thread(Counter *counter) {
  int K = 2;
  int D = 2;
  
  int n = 500000;
  double B = 10;

  int job;
  vector<Data> final_regrets;
  while ((job = counter->inc())) {
    cout << "working on job " << job << "\n";
    vector<double> alphas = {0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.82, 0.84, 0.86, 0.88, 0.90, 0.91, 0.92, 0.93, 0.94, 0.96, 0.98, 1.0};
    for (auto alpha : alphas) {
      MatrixXf nu(K, D);

      cout << "job id is " << job << " and working on alpha = " << alpha << "\n";

      nu(0,0) = 0.5;
      nu(0,1) = 0.5;

      nu(1,0) = 0.5 * alpha;
      nu(1,1) = 0.5 * alpha;
      Data point;

      vector<Data> data;
      AllocAlgorithm A(n, nu, B);
      A.alloc_alg(data, false);
      point.push_back(alpha);
      point.push_back(data[data.size()-1][1]);
      point.push_back(data[data.size()-1][4]);
      cout << "reward for alpha = " << alpha << " was " << point[2] << " and regret was " << point[1] << "\n";
      final_regrets.push_back(point);
    }

    write_data(final_regrets, "exp2/" + to_string(job) + ".txt");
  }
}


void exp1_thread(Counter *counter) {
  int K = 2;
  int D = 2;
  int n = 1000000;
  double B = 10;

  MatrixXf nu(K, D);

  nu(0,0) = 0.8;
  nu(0,1) = 0.4;

  nu(1,0) = 0.2;
  nu(1,1) = 2.0;

  int job;
  while ((job = counter->inc())) {
    cout << "working on job " << job << "\n";

    vector<Data> data1;
    vector<Data> data2;
    AllocAlgorithm A(n, nu, B);
    A.alloc_alg(data1, false);
    A.alloc_alg(data2, true);

    write_data(data1, "exp1/free." + to_string(job) + ".txt");
    write_data(data2, "exp1/fixed." + to_string(job) + ".txt");
  }
}


int main() {
  /* make sure Eigen uses thread-safety where possible */
  initParallel();

  /* how many threads would you like? */
  int n_threads = 8;

  /* iterate over experiments */
  for (auto &f : {exp2_thread}) {
    Counter counter(8);

    vector<thread> threads(n_threads);

    for (int i = 0;i!=n_threads;++i) {
      threads[i] = thread(f, &counter);
    }

    for (int i = 0;i!=n_threads;++i) {
      threads[i].join();
    }

  }
  return 0;
}



