#ifndef HEADER_DATA
#define HEADER_DATA

#include <vector>
#include <cmath>
#include <cstdint>
#include <algorithm>

class Data {
  public:

  double mean() {
    double sum = 0.0;
    for (auto x : data) {
      sum+=x / data.size();
    }
    return sum;
  }
  double variance() {
    double m = mean();
    double sum = 0.0;
    for (auto x : data) {
      sum+=pow(x - m, 2.0) / data.size();
    }
    return sum;
  }
  double standard_error() {
    return sqrt(variance() / data.size());
  }

  uint64_t size() {
    return data.size();
  }

  double quantile(double p) {
    if (!sorted) {
      std::sort(data.begin(), data.end());
    }
    sorted = true;
    return data[(int)(p * data.size())];
  }


  std::vector<double> data;

  Data() {
  }

  Data(double x) {
    data.push_back(x);
  }

  friend Data &operator<<(Data &d, double x) {
    d.data.push_back(x);
    d.sorted = false;
    return d;
  }

  bool sorted;
  private:
};


#endif
